(***************************************************************************
 This file is Copyright (C) 2005 Christoph Reichenbach

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the
   Free Software Foundation, Inc.
   59 Temple Place, Suite 330
   Boston, MA  02111-1307
   USA

 The author can be reached as "reichenb" at "colorado.edu".

***************************************************************************)

functor RLMakeFiniteTableApp (structure AppList : READLINE_APP_LIST) :> READLINE_APP
  where type App.t = AppList.t =
struct
      structure App =
      struct
            type t = AppList.t

	    val typename = AppList.typename
	    fun read (name : string) = let fun find_name []			= NONE
					     | find_name ((name', value)::tail)	= if name' = name
										  then SOME value
										  else find_name tail
				       in find_name AppList.mappings
				       end
	    fun completions () = map (fn (name, _) => name) AppList.mappings
      end

      structure RL_App = RLMakeApp(structure RLAppType = App)
      open RL_App
end