/***************************************************************************
 Copyright (C) 2005 Christoph Reichenbach <reichenb@colorado.edu>

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public Licence as
 published by the Free Software Foundaton; either version 2 of the
 Licence, or (at your option) any later version.

 It is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 merchantibility or fitness for a particular purpose. See the
 GNU General Public Licence for more details.

 You should have received a copy of the GNU General Public Licence
 along with this program; see the file COPYING. If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.

***************************************************************************/

/* Three different types of table */
extern const int table_type_regular;
/* In these, the 'completions' parts are useless */
extern const int table_type_number;
extern const int table_type_string;

typedef struct _completion_table {
	int type;	/* Type of the table in question */

	struct _completion_table *next_table; /* used for table_type_number, table_type_string, and whenever there is no match */

	int entries_nr;
	struct _completion_entry {
		char *string;
		struct _completion_table *next_table;
	} *entries;
} completion_table_t;

char *readline (const char *prompt);
/* Standard readline function */

void add_history (char *history);
/* Standard add_history function */

void set_readline_table (completion_table_t *table);
/* Sets the network of tables to use for readline completion */

void initialise_readline (char *procname);
/* Initialises readline */
