/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMASTMatcher {
    ASTNode _oldNode;
    ASTNode _newNode;
    ASTMatcher _builtInMatcher = new ASTMatcher();
    Map<ASTNode, ASTNode> _isomorphicNodes = new HashMap<ASTNode, ASTNode>();
    List<ASTNode> _newlyAddedNodes = new ArrayList<ASTNode>();

    public PMASTMatcher(ASTNode oldNode, ASTNode newNode) {
        this._newNode = newNode;
        this._oldNode = oldNode;
    }

    public boolean match() {
        boolean result = this.recursiveMatch(this._oldNode, this._newNode);
        if (!result) {
            this._isomorphicNodes.clear();
            this._newlyAddedNodes.clear();
        }
        return result;
    }

    public boolean recursiveMatch(ASTNode oldNode, ASTNode newNode) {
        List oldStructuralProperties;
        int old_type = oldNode.getNodeType();
        int new_type = newNode.getNodeType();
        if (!(old_type != 64 && old_type != 63 && old_type != 29 || new_type != 64 && new_type != 63 && new_type != 29)) {
            return true;
        }
        if (oldNode instanceof MethodDeclaration && newNode instanceof MethodDeclaration) {
            MethodDeclaration oldMethodDeclaration = (MethodDeclaration)oldNode;
            MethodDeclaration newMethodDeclaration = (MethodDeclaration)newNode;
            if (oldMethodDeclaration.isConstructor()) {
                newMethodDeclaration.setConstructor(true);
            }
        }
        if ((oldStructuralProperties = oldNode.structuralPropertiesForType()).size() == newNode.structuralPropertiesForType().size()) {
            for (StructuralPropertyDescriptor structuralPropertyDescriptor : oldStructuralProperties) {
                Object oldPropertyValue = oldNode.getStructuralProperty(structuralPropertyDescriptor);
                Object newPropertyValue = newNode.getStructuralProperty(structuralPropertyDescriptor);
                if (oldPropertyValue == null && newPropertyValue != null || newPropertyValue != null && newPropertyValue == null) {
                    return false;
                }
                if (oldPropertyValue == null && newPropertyValue == null) continue;
                if (structuralPropertyDescriptor.isSimpleProperty()) {
                    if (oldPropertyValue.equals(newPropertyValue)) continue;
                    return false;
                }
                if (structuralPropertyDescriptor.isChildProperty()) {
                    if (this.recursiveMatch((ASTNode)oldPropertyValue, (ASTNode)newPropertyValue)) continue;
                    return false;
                }
                if (structuralPropertyDescriptor.isChildListProperty()) {
                    List oldList = (List)oldPropertyValue;
                    List newList = (List)newPropertyValue;
                    if (oldList.size() == newList.size()) {
                        int i = 0;
                        while (i < oldList.size()) {
                            ASTNode newChildNode;
                            ASTNode oldChildNode = (ASTNode)oldList.get(i);
                            if (!this.recursiveMatch(oldChildNode, newChildNode = (ASTNode)newList.get(i))) {
                                return false;
                            }
                            ++i;
                        }
                        continue;
                    }
                    return false;
                }
                throw new RuntimeException("Unknown kind of structuralPropertyDescriptor");
            }
        } else {
            return false;
        }
        this._isomorphicNodes.put(oldNode, newNode);
        return true;
    }

    public List<ASTNode> newlyAddedNodes() {
        return this._newlyAddedNodes;
    }

    public Map<ASTNode, ASTNode> isomorphicNodes() {
        return this._isomorphicNodes;
    }
}

