/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring;

import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import pm_refactoring.PMProject;
import pm_refactoring.PMRenameProcessor;
import pm_refactoring.PMWorkspace;

public class PMRenameInputPage
extends UserInputWizardPage {
    Text fNameField;
    Label _warningLabel;
    PMRenameProcessor _processor;

    public PMRenameInputPage(PMRenameProcessor processor) {
        super("PM Refactoring Input Page");
        this._processor = processor;
    }

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        Label label = new Label(result, 0);
        label.setText("&New name:");
        this.fNameField = this.createNameField(result);
        Composite composite = new Composite(result, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this._warningLabel = this.createWarningLabel(composite);
        this.fNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                PMRenameInputPage.this.handleInputChanged();
            }
        });
        this.fNameField.setFocus();
        this.fNameField.selectAll();
        this.handleInputChanged();
    }

    private Text createNameField(Composite result) {
        Text field = new Text(result, 18436);
        field.setLayoutData((Object)new GridData(768));
        return field;
    }

    private Label createWarningLabel(Composite result) {
        Label warningLabel = new Label(result, 0);
        PMProject project = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._processor.getICompilationUnit().getJavaProject());
        if (project.sourcesAreOutOfSync()) {
            warningLabel.setText("External change detected.\nContinuing will reset the program model.");
        }
        return warningLabel;
    }

    void handleInputChanged() {
        this._processor.setNewName(this.fNameField.getText());
        RefactoringStatus status = new RefactoringStatus();
        this.setPageComplete(!status.hasError());
        int severity = status.getSeverity();
        String message = status.getMessageMatchingSeverity(severity);
        if (severity >= 1) {
            this.setMessage(message, severity);
        } else {
            this.setMessage("", 0);
        }
    }
}

