/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.analysis;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import pm_refactoring.analysis.PMUse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMDef {
    protected ASTNode _definingNode;
    protected Set<PMUse> _uses;

    public PMDef(ASTNode definingNode) {
        this._definingNode = definingNode;
        this._uses = new HashSet<PMUse>();
    }

    public String toString() {
        return "PMDef: " + this._definingNode + " [ " + this._uses.size() + " uses]";
    }

    public void addUse(PMUse use) {
        if (!this._uses.contains(use)) {
            this._uses.add(use);
            use.addReachingDefinition(this);
        }
    }

    public Set<PMUse> getUses() {
        return this._uses;
    }

    public ASTNode getDefiningNode() {
        return this._definingNode;
    }

    public IBinding findBindingForLHS(Expression lhs) {
        IBinding binding = null;
        if (lhs instanceof Name) {
            Name assignmentName = (Name)lhs;
            binding = assignmentName.resolveBinding();
        } else if (lhs instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)lhs;
            binding = fieldAccess.resolveFieldBinding();
        } else {
            throw new RuntimeException("Don't know how to find binding for " + lhs.getClass().getCanonicalName() + " [" + lhs + "]");
        }
        return binding;
    }

    public IBinding getBinding() {
        IBinding result = null;
        if (this._definingNode instanceof Assignment) {
            Assignment assignment = (Assignment)this._definingNode;
            result = this.findBindingForLHS(assignment.getLeftHandSide());
        } else if (this._definingNode instanceof SingleVariableDeclaration) {
            SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)this._definingNode;
            result = this.findBindingForLHS((Expression)singleVariableDeclaration.getName());
        } else if (this._definingNode instanceof VariableDeclarationFragment) {
            VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)this._definingNode;
            result = this.findBindingForLHS((Expression)variableDeclarationFragment.getName());
        } else if (this._definingNode instanceof PostfixExpression) {
            PostfixExpression postfixExpression = (PostfixExpression)this._definingNode;
            result = this.findBindingForLHS(postfixExpression.getOperand());
        } else if (this._definingNode instanceof PrefixExpression) {
            PrefixExpression prefixExpression = (PrefixExpression)this._definingNode;
            result = this.findBindingForLHS(prefixExpression.getOperand());
        } else {
            throw new RuntimeException("Un-handled _definingNode type " + this._definingNode.getClass());
        }
        return result;
    }

    public static VariableDeclaration localDeclarationForSimpleName(SimpleName simpleName) {
        return (VariableDeclaration)((CompilationUnit)simpleName.getRoot()).findDeclaringNode(simpleName.resolveBinding());
    }
}

