/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.inconsistencies;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import pm_refactoring.PMProject;
import pm_refactoring.PMWorkspace;
import pm_refactoring.inconsistencies.PMInconsistency;

public class PMMarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    public static final String INCONSISTENCY_ID = "pm-inconsistency-id";
    public static final String PROJECT_ID = "pm-project-id";
    public static final String ACCEPTS_BEHAVIORAL_CHANGE = "pm-accepts-behavioral-change";

    public IMarkerResolution[] getResolutions(IMarker marker) {
        System.out.println("Getting resolutions");
        try {
            PMProject project = PMWorkspace.sharedWorkspace().projectForIJavaProject((IJavaProject)JavaCore.create((String)((String)marker.getAttribute(PROJECT_ID))));
            String inconsistencyID = (String)marker.getAttribute(INCONSISTENCY_ID);
            PMInconsistency inconsistency = project.getInconsistencyWithKey(inconsistencyID);
            IMarkerResolution[] result = new IMarkerResolution[]{new AcceptBehavioralChangeQuickFix(inconsistency)};
            return result;
        }
        catch (Exception exception) {
            return new IMarkerResolution[0];
        }
    }

    public static class AcceptBehavioralChangeQuickFix
    implements IMarkerResolution {
        PMInconsistency _inconsistency;

        AcceptBehavioralChangeQuickFix(PMInconsistency inconsistency) {
            this._inconsistency = inconsistency;
        }

        public String getLabel() {
            return "Accept behavioral change.";
        }

        public void run(IMarker marker) {
            this._inconsistency.acceptBehavioralChange();
        }
    }
}

