/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.inconsistencies;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import pm_refactoring.PMCompilationUnit;
import pm_refactoring.PMProject;
import pm_refactoring.inconsistencies.PMInconsistency;
import pm_refactoring.models.PMNameModel;

public class PMNameCapture
extends PMInconsistency {
    protected ASTNode _expectedDeclaration;
    protected ASTNode _actualDeclaration;

    public PMNameCapture(PMProject project, PMCompilationUnit iCompilationUnit, ASTNode capturedNode, ASTNode expectedDeclaration, ASTNode actualDeclaration) {
        super(project, iCompilationUnit, capturedNode);
        this._expectedDeclaration = expectedDeclaration;
        this._actualDeclaration = actualDeclaration;
    }

    public ASTNode getCapturedNode() {
        return this._node;
    }

    public ASTNode getExpectedDeclaration() {
        return this._expectedDeclaration;
    }

    public ASTNode getActualDeclaration() {
        return this._actualDeclaration;
    }

    public String getCapturedNodeDescription() {
        if (this._node instanceof SimpleName) {
            return ((SimpleName)this._node).getIdentifier();
        }
        return "Unknown node";
    }

    public String getHumanReadableDescription() {
        return String.valueOf(this.getCapturedNodeDescription()) + " was captured.";
    }

    public boolean allowsAcceptBehavioralChange() {
        return true;
    }

    public void acceptBehavioralChange() {
        Name capturedName = (Name)this.getCapturedNode();
        PMNameModel nameModel = this._project.getNameModel();
        SimpleName capturingName = this._project.simpleNameForDeclaringNode(this._actualDeclaration);
        String capturingIdentifier = nameModel.identifierForName((Name)capturingName);
        nameModel.setIdentifierForName(capturingIdentifier, capturedName);
        this._project.rescanForInconsistencies();
    }
}

