/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.models;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import pm_refactoring.PMNodeReference;
import pm_refactoring.PMProject;
import pm_refactoring.PMTimer;
import pm_refactoring.analysis.PMDef;
import pm_refactoring.analysis.PMRDefsAnalysis;
import pm_refactoring.analysis.PMUse;
import pm_refactoring.inconsistencies.PMExtraDefinition;
import pm_refactoring.inconsistencies.PMInconsistency;
import pm_refactoring.inconsistencies.PMMissingDefinition;
import pm_refactoring.inconsistencies.PMUnknownUse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMUDModel {
    protected PMProject _project;
    final ASTNode _uninitializedMarkerNode;
    final PMNodeReference _uninitialized;
    Map<PMNodeReference, Set<PMNodeReference>> _definitionIdentifiersByUseIdentifier;
    Map<PMNodeReference, Set<PMNodeReference>> _useIdentifiersByDefinitionIdentifier;

    public PMUDModel(PMProject project) {
        this._project = project;
        AST ast = AST.newAST((int)3);
        this._uninitializedMarkerNode = ast.newSimpleName("Foo");
        this._uninitialized = this._project.getReferenceForNode(this._uninitializedMarkerNode);
        this._definitionIdentifiersByUseIdentifier = new HashMap<PMNodeReference, Set<PMNodeReference>>();
        this._useIdentifiersByDefinitionIdentifier = new HashMap<PMNodeReference, Set<PMNodeReference>>();
        this.initializeModel();
    }

    public boolean nameIsUse(SimpleName name) {
        PMNodeReference nameReference = this._project.getReferenceForNode((ASTNode)name);
        return this._definitionIdentifiersByUseIdentifier.containsKey(nameReference);
    }

    public Set<PMNodeReference> definitionIdentifiersForName(PMNodeReference nameIdentifier) {
        Set<PMNodeReference> definitionIdentifiers = this._definitionIdentifiersByUseIdentifier.get(nameIdentifier);
        if (definitionIdentifiers == null) {
            definitionIdentifiers = new HashSet<PMNodeReference>();
            this._definitionIdentifiersByUseIdentifier.put(nameIdentifier, definitionIdentifiers);
        }
        return definitionIdentifiers;
    }

    public void addDefinitionIdentifierForName(PMNodeReference definitionIdentifier, PMNodeReference nameIdentifier) {
        this.definitionIdentifiersForName(nameIdentifier).add(definitionIdentifier);
        this.addUseForDefinition(nameIdentifier, definitionIdentifier);
    }

    public void removeDefinitionIdentifierForName(PMNodeReference definitionIdentifier, PMNodeReference nameIdentifier) {
        this.definitionIdentifiersForName(nameIdentifier).remove(definitionIdentifier);
        this.removeUseForDefinition(nameIdentifier, definitionIdentifier);
    }

    public Set<PMNodeReference> usesForDefinition(PMNodeReference definitionIdentifier) {
        Set<PMNodeReference> useIdentifiers = this._useIdentifiersByDefinitionIdentifier.get(definitionIdentifier);
        if (useIdentifiers == null) {
            useIdentifiers = new HashSet<PMNodeReference>();
            this._useIdentifiersByDefinitionIdentifier.put(definitionIdentifier, useIdentifiers);
        }
        return useIdentifiers;
    }

    public void addUseForDefinition(PMNodeReference useIdentifier, PMNodeReference definitionIdentifier) {
        this.usesForDefinition(definitionIdentifier).add(useIdentifier);
    }

    public void removeUseForDefinition(PMNodeReference useIdentifier, PMNodeReference definitionIdentifier) {
        this.usesForDefinition(definitionIdentifier).remove(useIdentifier);
    }

    public void deleteDefinition(PMNodeReference definition) {
        for (PMNodeReference use : this.usesForDefinition(definition)) {
            this.removeDefinitionIdentifierForName(definition, use);
        }
        this._useIdentifiersByDefinitionIdentifier.remove(definition);
    }

    public void addUseToModel(PMUse use) {
        SimpleName name = use.getSimpleName();
        PMNodeReference nameIdentifier = this._project.getReferenceForNode((ASTNode)name);
        this.definitionIdentifiersForName(nameIdentifier);
        for (PMDef def : use.getReachingDefinitions()) {
            PMNodeReference definitionIdentifier;
            if (def != null) {
                ASTNode definingNode = def.getDefiningNode();
                definitionIdentifier = this._project.getReferenceForNode(definingNode);
                if (definitionIdentifier == null) {
                    throw new RuntimeException("Couldn't find identifier for defining node " + definingNode);
                }
            } else {
                definitionIdentifier = this._uninitialized;
            }
            this.addDefinitionIdentifierForName(definitionIdentifier, nameIdentifier);
        }
    }

    protected void addUsesToModel(Collection<PMUse> uses) {
        for (PMUse use : uses) {
            this.addUseToModel(use);
        }
    }

    protected Collection<PMUse> getCurrentUses() {
        PMTimer.sharedTimer().start("DUUD_CHAINS");
        final HashSet<PMUse> uses = new HashSet<PMUse>();
        for (ASTNode root : this._project.getASTRoots()) {
            root.accept(new ASTVisitor(){

                public boolean visit(MethodDeclaration methodDeclaration) {
                    if (methodDeclaration.getBody() != null) {
                        PMRDefsAnalysis analysis = new PMRDefsAnalysis(methodDeclaration);
                        uses.addAll(analysis.getUses());
                    }
                    return false;
                }
            });
        }
        PMTimer.sharedTimer().stop("DUUD_CHAINS");
        return uses;
    }

    protected void initializeModel() {
        this.addUsesToModel(this.getCurrentUses());
    }

    protected Collection<ASTNode> definingNodesForUse(PMUse use) {
        HashSet<ASTNode> definingNodes = new HashSet<ASTNode>();
        for (PMDef definition : use.getReachingDefinitions()) {
            if (definition != null) {
                definingNodes.add(definition.getDefiningNode());
                continue;
            }
            definingNodes.add(null);
        }
        return definingNodes;
    }

    public Collection<PMInconsistency> calculateInconsistencies() {
        HashSet<PMInconsistency> inconsistencies = new HashSet<PMInconsistency>();
        Collection<PMUse> uses = this.getCurrentUses();
        PMTimer.sharedTimer().start("INCONSISTENCIES");
        for (PMUse use : uses) {
            SimpleName usingNode = use.getSimpleName();
            Collection<ASTNode> currentDefiningNodes = this.definingNodesForUse(use);
            PMNodeReference useNameIdentifier = this._project.getReferenceForNode((ASTNode)usingNode);
            if (useNameIdentifier != null) {
                Set<PMNodeReference> desiredDefinitionIdentifiers = this._definitionIdentifiersByUseIdentifier.get(useNameIdentifier);
                if (desiredDefinitionIdentifiers != null) {
                    for (PMNodeReference desiredDefinitionIdentifier : desiredDefinitionIdentifiers) {
                        ASTNode desiredDefiningNode;
                        if (!desiredDefinitionIdentifier.equals(this._uninitialized)) {
                            desiredDefiningNode = desiredDefinitionIdentifier.getNode();
                            if (desiredDefiningNode == null) {
                                throw new RuntimeException("Couldn't find defining node for identifier:" + desiredDefinitionIdentifier + "for use " + usingNode);
                            }
                        } else {
                            desiredDefiningNode = null;
                        }
                        if (currentDefiningNodes.contains(desiredDefiningNode)) continue;
                        inconsistencies.add(new PMMissingDefinition(this._project, this._project.findPMCompilationUnitForNode((ASTNode)usingNode), (ASTNode)usingNode, desiredDefiningNode));
                    }
                } else {
                    inconsistencies.add(new PMUnknownUse(this._project, this._project.findPMCompilationUnitForNode((ASTNode)usingNode), use.getSimpleName()));
                    continue;
                }
                for (ASTNode currentDefiningNode : currentDefiningNodes) {
                    PMNodeReference currentDefiningIdentifier = null;
                    if (currentDefiningNode != null) {
                        currentDefiningIdentifier = this._project.getReferenceForNode(currentDefiningNode);
                        if (currentDefiningIdentifier == null) {
                            new RuntimeException("Couldn't find  identifier for current defining node " + currentDefiningNode);
                        }
                    } else {
                        currentDefiningIdentifier = this._uninitialized;
                    }
                    if (desiredDefinitionIdentifiers.contains(currentDefiningIdentifier)) continue;
                    inconsistencies.add(new PMExtraDefinition(this._project, this._project.findPMCompilationUnitForNode((ASTNode)usingNode), (ASTNode)usingNode, currentDefiningNode));
                }
                continue;
            }
            throw new RuntimeException("Couldn't find use identifier for use:" + use.getSimpleName());
        }
        PMTimer.sharedTimer().stop("INCONSISTENCIES");
        return inconsistencies;
    }
}

