/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.selection;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class PMInsertionPoint {
    CompilationUnit _compilationUnit;
    int _offset;
    int _insertionIndex = -1;
    ChildListPropertyDescriptor _insertionProperty;
    ASTNode _insertionParent;

    public PMInsertionPoint(CompilationUnit compilationUnit, int offset) {
        this._compilationUnit = compilationUnit;
        this._offset = offset;
        if (!this.findInsertionPointInBlock(this._offset)) {
            this.findInsertionPointInTypeDeclaration(this._offset);
        }
    }

    public boolean isSaneInsertionPoint() {
        return this._insertionIndex != -1;
    }

    public int insertionIndex() {
        return this._insertionIndex;
    }

    public ChildListPropertyDescriptor insertionProperty() {
        return this._insertionProperty;
    }

    public ASTNode insertionParent() {
        return this._insertionParent;
    }

    private boolean findInsertionPointUnderNode(ASTNode parentNode, ChildListPropertyDescriptor property, int offset) {
        List statements = (List)parentNode.getStructuralProperty((StructuralPropertyDescriptor)property);
        int statementCount = statements.size();
        if (statementCount > 0) {
            if (offset <= ((ASTNode)statements.get(0)).getStartPosition()) {
                this._insertionIndex = 0;
            } else {
                ASTNode lastStatement = (ASTNode)statements.get(statementCount - 1);
                if (offset >= lastStatement.getStartPosition() + lastStatement.getLength()) {
                    this._insertionIndex = statementCount;
                } else {
                    int i = 1;
                    while (i < statementCount) {
                        ASTNode statement1 = (ASTNode)statements.get(i - 1);
                        ASTNode statement2 = (ASTNode)statements.get(i);
                        if (offset >= statement1.getStartPosition() + statement1.getLength() && offset <= statement2.getStartPosition()) {
                            this._insertionIndex = i;
                            break;
                        }
                        ++i;
                    }
                }
            }
        } else {
            this._insertionIndex = 0;
        }
        if (this._insertionIndex != -1) {
            this._insertionParent = parentNode;
            this._insertionProperty = property;
            return true;
        }
        this._insertionParent = null;
        this._insertionProperty = null;
        return false;
    }

    private boolean findInsertionPointInBlock(int offset) {
        Block containingBlock = PMInsertionPoint.FindContainingBlockForSelection((ASTNode)this._compilationUnit, offset, 0);
        if (containingBlock != null) {
            return this.findInsertionPointUnderNode((ASTNode)containingBlock, Block.STATEMENTS_PROPERTY, offset);
        }
        this._insertionIndex = -1;
        return false;
    }

    private boolean findInsertionPointInTypeDeclaration(int offset) {
        TypeDeclaration containingTypeDeclaration = PMInsertionPoint.FindContainingTypeDeclarationForSelection((ASTNode)this._compilationUnit, offset, 0);
        if (containingTypeDeclaration != null) {
            return this.findInsertionPointUnderNode((ASTNode)containingTypeDeclaration, TypeDeclaration.BODY_DECLARATIONS_PROPERTY, offset);
        }
        System.err.println("Couldn't find containing type declaration");
        this._insertionIndex = -1;
        return false;
    }

    private static Block FindContainingBlockForSelection(ASTNode nodeToSearch, int offset, int length) {
        PMContainingBlockVisitor containingBlockVisitor = new PMContainingBlockVisitor(offset, length);
        nodeToSearch.accept((ASTVisitor)containingBlockVisitor);
        return (Block)containingBlockVisitor.getContainingNode();
    }

    private static TypeDeclaration FindContainingTypeDeclarationForSelection(ASTNode nodeToSearch, int offset, int length) {
        PMContainingTypeDeclarationVisitor containingTypeDeclarationVisitor = new PMContainingTypeDeclarationVisitor(offset, length);
        nodeToSearch.accept((ASTVisitor)containingTypeDeclarationVisitor);
        return (TypeDeclaration)containingTypeDeclarationVisitor.getContainingNode();
    }

    protected static class PMContainingBlockVisitor
    extends PMContainingNodeVisitor {
        public PMContainingBlockVisitor(int offset, int length) {
            super(offset, length);
        }

        public boolean visit(Block block) {
            return this.visitContainingNode((ASTNode)block);
        }
    }

    protected static class PMContainingNodeVisitor
    extends ASTVisitor {
        int _offset;
        int _length;
        ASTNode _containingNode = null;

        public PMContainingNodeVisitor(int offset, int length) {
            this._offset = offset;
            this._length = length;
        }

        public boolean visitContainingNode(ASTNode node) {
            if (node.getStartPosition() + 1 <= this._offset && this._offset + this._length <= node.getStartPosition() + node.getLength() - 1) {
                this._containingNode = node;
                return true;
            }
            return false;
        }

        public ASTNode getContainingNode() {
            return this._containingNode;
        }
    }

    protected static class PMContainingTypeDeclarationVisitor
    extends PMContainingNodeVisitor {
        public PMContainingTypeDeclarationVisitor(int offset, int length) {
            super(offset, length);
        }

        public boolean visit(TypeDeclaration typeDeclaration) {
            return this.visitContainingNode((ASTNode)typeDeclaration);
        }
    }
}

