/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.selection;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import pm_refactoring.selection.PMInsertionPoint;

public class PMSelection {
    CompilationUnit _compilationUnit;
    int _offset;
    int _length;
    ASTNode _singleSelectedNode;
    ASTNode _propertyParentNode;
    StructuralPropertyDescriptor _selectedPropertyDescriptor;
    int _childListPropertyOffset;
    int _childListPropertyLength;

    public PMSelection(CompilationUnit compilationUnit, int offset, int length) {
        this._compilationUnit = compilationUnit;
        this._offset = offset;
        this._length = length;
        this._childListPropertyOffset = -1;
        this._childListPropertyLength = -1;
        this.trimWhitespace();
        this.findSelection(this._offset, this._length);
    }

    public ASTNode singleSelectedNode() {
        return this._singleSelectedNode;
    }

    public ASTNode[] selectedNodes() {
        return new ASTNode[0];
    }

    public StructuralPropertyDescriptor selectedNodeParentProperty() {
        return this._selectedPropertyDescriptor;
    }

    public ASTNode selectedNodeParent() {
        if (this._singleSelectedNode != null) {
            return this._singleSelectedNode.getParent();
        }
        return this._propertyParentNode;
    }

    public int selectedNodeParentPropertyListOffset() {
        return this._childListPropertyOffset;
    }

    public int selectedNodeParentPropertyListLength() {
        return this._childListPropertyLength;
    }

    public boolean isListSelection() {
        return this._selectedPropertyDescriptor instanceof ChildListPropertyDescriptor;
    }

    public boolean isMultipleSelection() {
        return this._childListPropertyLength > 0;
    }

    public boolean isSaneSelection() {
        return this._selectedPropertyDescriptor != null || this._singleSelectedNode != null;
    }

    private void findSelection(int offset, int length) {
        PMExactSelectionVisitor selectionVisitor = new PMExactSelectionVisitor(offset, length);
        this._compilationUnit.accept((ASTVisitor)selectionVisitor);
        ASTNode containingNode = selectionVisitor.getContainingNode();
        if (containingNode.getStartPosition() == offset && containingNode.getLength() == length) {
            this._singleSelectedNode = containingNode;
        } else {
            this._singleSelectedNode = null;
            PMInsertionPoint startInsertionPoint = new PMInsertionPoint(this._compilationUnit, offset);
            PMInsertionPoint endInsertionPoint = new PMInsertionPoint(this._compilationUnit, offset + length);
            if (startInsertionPoint.isSaneInsertionPoint() && endInsertionPoint.isSaneInsertionPoint() && startInsertionPoint.insertionParent() == endInsertionPoint.insertionParent() && startInsertionPoint.insertionProperty().equals(endInsertionPoint.insertionProperty())) {
                this._propertyParentNode = startInsertionPoint.insertionParent();
                this._selectedPropertyDescriptor = startInsertionPoint.insertionProperty();
                this._childListPropertyOffset = startInsertionPoint.insertionIndex();
                this._childListPropertyLength = endInsertionPoint.insertionIndex() - startInsertionPoint.insertionIndex();
            }
        }
    }

    public String getSelectionAsString() {
        String result = null;
        String entireSource = null;
        try {
            ICompilationUnit iCompilationUnit = (ICompilationUnit)this._compilationUnit.getJavaElement();
            entireSource = iCompilationUnit != null ? ((ICompilationUnit)this._compilationUnit.getJavaElement()).getSource() : this._compilationUnit.toString();
        }
        catch (JavaModelException e) {
            System.err.println("Exception in PMSelection.getSelectionAsString(): " + (Object)((Object)e));
            throw new RuntimeException(e);
        }
        result = entireSource.substring(this._offset, this._offset + this._length);
        return result;
    }

    private void trimWhitespace() {
        String selection = this.getSelectionAsString();
        int index = 0;
        while (index < selection.length()) {
            if (!Character.isWhitespace(selection.charAt(index))) break;
            ++this._offset;
            --this._length;
            ++index;
        }
        index = selection.length() - 1;
        while (index >= 0) {
            if (!Character.isWhitespace(selection.charAt(index))) break;
            --this._length;
            --index;
        }
    }

    protected static class PMExactSelectionVisitor
    extends GenericVisitor {
        int _offset;
        int _length;
        ASTNode _containingNode;

        public PMExactSelectionVisitor(int offset, int length) {
            this._offset = offset;
            this._length = length;
        }

        protected boolean nodeContainsSelection(ASTNode node, int offset, int length) {
            return offset >= node.getStartPosition() && offset + length <= node.getStartPosition() + node.getLength();
        }

        public boolean visitNode(ASTNode node) {
            if (this.nodeContainsSelection(node, this._offset, this._length)) {
                this._containingNode = node;
                return true;
            }
            return false;
        }

        public ASTNode getContainingNode() {
            return this._containingNode;
        }
    }
}

