/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.steps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import pm_refactoring.PMNodeReference;
import pm_refactoring.PMPasteboard;
import pm_refactoring.PMProject;
import pm_refactoring.analysis.PMRDefsAnalysis;
import pm_refactoring.models.PMNameModel;
import pm_refactoring.models.PMUDModel;
import pm_refactoring.steps.PMStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMCopyStep
extends PMStep {
    List<ASTNode> _selectedNodes;

    public PMCopyStep(PMProject project, List<ASTNode> selectedNodes) {
        super(project);
        this.initWithSelectedNodes(selectedNodes);
    }

    public PMCopyStep(PMProject project, ASTNode node) {
        super(project);
        ArrayList<ASTNode> selectedNodes = new ArrayList<ASTNode>();
        selectedNodes.add(node);
        this.initWithSelectedNodes(selectedNodes);
    }

    private void initWithSelectedNodes(List<ASTNode> selectedNodes) {
        this._selectedNodes = selectedNodes;
    }

    @Override
    public Map<ICompilationUnit, ASTRewrite> calculateTextualChange() {
        HashMap<ICompilationUnit, ASTRewrite> result = new HashMap<ICompilationUnit, ASTRewrite>();
        return result;
    }

    public void copyNameModel(List<ASTNode> originalRootNodes, List<ASTNode> copiedRootNodes) {
        final PMNameModel nameModel = this._project.getNameModel();
        final HashMap copyNameIdentifiersForOriginals = new HashMap();
        ASTMatcher matcher = new ASTMatcher(){

            public boolean match(SimpleName originalName, Object copyNameObject) {
                SimpleName copyName = (SimpleName)copyNameObject;
                if (PMCopyStep.this._project.nameNodeIsDeclaring(originalName)) {
                    String freshNameModelIdentifier = nameModel.generateNewIdentifierForName((Name)copyName);
                    nameModel.setIdentifierForName(freshNameModelIdentifier, (Name)copyName);
                    copyNameIdentifiersForOriginals.put(nameModel.identifierForName((Name)originalName), freshNameModelIdentifier);
                } else {
                    nameModel.setIdentifierForName(nameModel.identifierForName((Name)originalName), (Name)copyName);
                }
                return true;
            }
        };
        int i = 0;
        while (i < originalRootNodes.size()) {
            ASTNode original = originalRootNodes.get(i);
            ASTNode copy = copiedRootNodes.get(i);
            original.subtreeMatch(matcher, (Object)copy);
            ++i;
        }
        ASTVisitor fixupReferenceVisitor = new ASTVisitor(){

            public boolean visit(SimpleName name) {
                String nameIdentifier = nameModel.identifierForName((Name)name);
                if (copyNameIdentifiersForOriginals.containsKey(nameIdentifier)) {
                    nameModel.setIdentifierForName((String)copyNameIdentifiersForOriginals.get(nameIdentifier), (Name)name);
                }
                return true;
            }
        };
        for (ASTNode copiedPasteboardRoot : copiedRootNodes) {
            copiedPasteboardRoot.accept(fixupReferenceVisitor);
        }
    }

    public void copyUDModel(List<ASTNode> originalRootNodes, List<ASTNode> copiedRootNodes) {
        final PMUDModel udModel = this._project.getUDModel();
        final HashMap originalUsingNodesForCopiedUsingNodes = new HashMap();
        final HashMap copiedUsingNodesForOriginalUsingNodes = new HashMap();
        ASTMatcher nameMatcher = new ASTMatcher(){

            public boolean match(SimpleName originalName, Object copyNameObject) {
                SimpleName copyName = (SimpleName)copyNameObject;
                if (udModel.nameIsUse(originalName)) {
                    originalUsingNodesForCopiedUsingNodes.put(copyName, originalName);
                    copiedUsingNodesForOriginalUsingNodes.put(originalName, copyName);
                }
                return true;
            }
        };
        HashMap<ASTNode, ASTNode> originalDefiningNodesForCopiedDefiningNodes = new HashMap<ASTNode, ASTNode>();
        HashMap<ASTNode, ASTNode> copiedDefiningNodesForCopiedOriginalDefiningNodes = new HashMap<ASTNode, ASTNode>();
        int rootNodeIndex = 0;
        while (rootNodeIndex < originalRootNodes.size()) {
            ASTNode originalRootNode = originalRootNodes.get(rootNodeIndex);
            ASTNode copyRootNode = copiedRootNodes.get(rootNodeIndex);
            List<ASTNode> originalDefiningNodes = PMRDefsAnalysis.findDefiningNodesUnderNode(originalRootNode);
            List<ASTNode> copyDefiningNodes = PMRDefsAnalysis.findDefiningNodesUnderNode(copyRootNode);
            int definingNodeIndex = 0;
            while (definingNodeIndex < originalDefiningNodes.size()) {
                ASTNode originalDefiningNode = originalDefiningNodes.get(definingNodeIndex);
                ASTNode copyDefiningNode = copyDefiningNodes.get(definingNodeIndex);
                originalDefiningNodesForCopiedDefiningNodes.put(copyDefiningNode, originalDefiningNode);
                copiedDefiningNodesForCopiedOriginalDefiningNodes.put(originalDefiningNode, copyDefiningNode);
                ++definingNodeIndex;
            }
            originalRootNode.subtreeMatch(nameMatcher, (Object)copyRootNode);
            ++rootNodeIndex;
        }
        for (ASTNode copiedDefinition : originalDefiningNodesForCopiedDefiningNodes.keySet()) {
            ASTNode originalDefinition = (ASTNode)originalDefiningNodesForCopiedDefiningNodes.get(copiedDefinition);
            Set<PMNodeReference> originalUses = udModel.usesForDefinition(this._project.getReferenceForNode(originalDefinition));
            Set<PMNodeReference> copyUses = udModel.usesForDefinition(this._project.getReferenceForNode(copiedDefinition));
            for (PMNodeReference originalUseReference : originalUses) {
                ASTNode originalUseNode = originalUseReference.getNode();
                ASTNode copyUseNode = (ASTNode)copiedUsingNodesForOriginalUsingNodes.get(originalUseNode);
                if (copyUseNode != null) {
                    copyUses.add(this._project.getReferenceForNode(copyUseNode));
                    continue;
                }
                copyUses.add(originalUseReference);
            }
        }
        for (ASTNode copiedUse : originalUsingNodesForCopiedUsingNodes.keySet()) {
            ASTNode originalUse = (ASTNode)originalUsingNodesForCopiedUsingNodes.get(copiedUse);
            Set<PMNodeReference> originalDefinitions = udModel.definitionIdentifiersForName(this._project.getReferenceForNode(originalUse));
            Set<PMNodeReference> copyDefinitions = udModel.definitionIdentifiersForName(this._project.getReferenceForNode(copiedUse));
            for (PMNodeReference originalDefinitionReference : originalDefinitions) {
                ASTNode originalDefinitionNode = originalDefinitionReference.getNode();
                ASTNode copyDefinitionNode = (ASTNode)copiedDefiningNodesForCopiedOriginalDefiningNodes.get(originalDefinitionNode);
                if (copyDefinitionNode != null) {
                    copyDefinitions.add(this._project.getReferenceForNode(copyDefinitionNode));
                    continue;
                }
                copyDefinitions.add(originalDefinitionReference);
            }
        }
    }

    @Override
    public void performASTChange() {
        ArrayList<ASTNode> copiedPasteboardRootNodes = new ArrayList<ASTNode>();
        for (ASTNode original : this._selectedNodes) {
            ASTNode copy = ASTNode.copySubtree((AST)original.getAST(), (ASTNode)original);
            copiedPasteboardRootNodes.add(copy);
        }
        this.copyNameModel(this._selectedNodes, copiedPasteboardRootNodes);
        this.copyUDModel(this._selectedNodes, copiedPasteboardRootNodes);
        PMPasteboard pasteboard = this._project.getPasteboard();
        pasteboard.setPasteboardRoots(copiedPasteboardRootNodes);
    }

    @Override
    public void updateAfterReparse() {
    }

    @Override
    public void cleanup() {
    }
}

