/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.steps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import pm_refactoring.PMPasteboard;
import pm_refactoring.PMProject;
import pm_refactoring.steps.PMStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMCutStep
extends PMStep {
    List<ASTNode> _selectedNodes;

    public PMCutStep(PMProject project, List<ASTNode> selectedNodes) {
        super(project);
        this.initWithSelectedNodes(selectedNodes);
    }

    public PMCutStep(PMProject project, ASTNode node) {
        super(project);
        ArrayList<ASTNode> selectedNodes = new ArrayList<ASTNode>();
        selectedNodes.add(node);
        this.initWithSelectedNodes(selectedNodes);
    }

    private void initWithSelectedNodes(List<ASTNode> selectedNodes) {
        this._selectedNodes = selectedNodes;
    }

    @Override
    public Map<ICompilationUnit, ASTRewrite> calculateTextualChange() {
        HashMap<ICompilationUnit, ASTRewrite> result = new HashMap<ICompilationUnit, ASTRewrite>();
        ASTRewrite astRewrite = ASTRewrite.create((AST)this._selectedNodes.get(0).getAST());
        for (ASTNode node : this._selectedNodes) {
            astRewrite.remove(node, null);
            result.put(this._project.findPMCompilationUnitForNode(node).getICompilationUnit(), astRewrite);
        }
        return result;
    }

    @Override
    public void performASTChange() {
        PMPasteboard pasteboard = this._project.getPasteboard();
        pasteboard.setPasteboardRoots(this._selectedNodes);
        for (ASTNode node : this._selectedNodes) {
            node.delete();
        }
    }

    @Override
    public void updateAfterReparse() {
    }

    @Override
    public void cleanup() {
    }
}

