/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.steps;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import pm_refactoring.PMNodeReference;
import pm_refactoring.PMProject;
import pm_refactoring.analysis.PMRDefsAnalysis;
import pm_refactoring.analysis.PMUse;
import pm_refactoring.models.PMNameModel;
import pm_refactoring.models.PMUDModel;
import pm_refactoring.steps.PMStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMDelegateStep
extends PMStep {
    ASTNode _selectedNode;
    String _delegateIdentifier;
    SuperMethodInvocation _newSuperInvocationNode;
    MethodInvocation _selectedMethodInvocation;
    Expression _newExpressionNode;
    PMNodeReference _newExpressionNodeReference;
    ICompilationUnit _iCompilationUnit;

    public PMDelegateStep(PMProject project, ASTNode selectedNode) {
        super(project);
        this._selectedNode = selectedNode;
        CompilationUnit containingCompilationUnit = (CompilationUnit)this._selectedNode.getRoot();
        this._iCompilationUnit = (ICompilationUnit)containingCompilationUnit.getJavaElement();
    }

    public String getDelegateIdentifier() {
        return this._delegateIdentifier;
    }

    public void setDelegateIdentifier(String delegateIdentifier) {
        this._delegateIdentifier = delegateIdentifier;
    }

    void rewriteToDelegateMethodInvocationToIdentifier(ASTRewrite astRewrite, MethodInvocation methodInvocation, Expression identifierNode) {
        astRewrite.set((ASTNode)methodInvocation, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)identifierNode, null);
    }

    void rewriteToDelegateMethodInvocationToSuperInvocation(ASTRewrite astRewrite, MethodInvocation methodInvocation, Expression superInvocationNode) {
        astRewrite.replace((ASTNode)methodInvocation, (ASTNode)superInvocationNode, null);
    }

    SuperMethodInvocation superMethodDelegatingMethodInvocation(MethodInvocation invocationToDelegate) {
        AST ast = invocationToDelegate.getAST();
        SuperMethodInvocation superMethodInvocationNode = ast.newSuperMethodInvocation();
        superMethodInvocationNode.setStructuralProperty((StructuralPropertyDescriptor)SuperMethodInvocation.NAME_PROPERTY, (Object)ASTNode.copySubtree((AST)ast, (ASTNode)((ASTNode)invocationToDelegate.getStructuralProperty((StructuralPropertyDescriptor)MethodInvocation.NAME_PROPERTY))));
        superMethodInvocationNode.arguments().addAll(ASTNode.copySubtrees((AST)ast, (List)((List)invocationToDelegate.getStructuralProperty((StructuralPropertyDescriptor)MethodInvocation.ARGUMENTS_PROPERTY))));
        superMethodInvocationNode.arguments().addAll(ASTNode.copySubtrees((AST)ast, (List)((List)invocationToDelegate.getStructuralProperty((StructuralPropertyDescriptor)MethodInvocation.TYPE_ARGUMENTS_PROPERTY))));
        return superMethodInvocationNode;
    }

    @Override
    public Map<ICompilationUnit, ASTRewrite> calculateTextualChange() {
        HashMap<ICompilationUnit, ASTRewrite> result = new HashMap<ICompilationUnit, ASTRewrite>();
        if (this._selectedNode instanceof MethodInvocation) {
            this._selectedMethodInvocation = (MethodInvocation)this._selectedNode;
            AST ast = this._selectedMethodInvocation.getAST();
            ASTRewrite astRewrite = ASTRewrite.create((AST)ast);
            if (this._delegateIdentifier.equals("super")) {
                this._newExpressionNode = null;
                this._newSuperInvocationNode = this.superMethodDelegatingMethodInvocation(this._selectedMethodInvocation);
                this.rewriteToDelegateMethodInvocationToSuperInvocation(astRewrite, this._selectedMethodInvocation, (Expression)this._newSuperInvocationNode);
            } else {
                this._newExpressionNode = !this._delegateIdentifier.equals("") ? ast.newSimpleName(this._delegateIdentifier) : null;
                this.rewriteToDelegateMethodInvocationToIdentifier(astRewrite, this._selectedMethodInvocation, this._newExpressionNode);
            }
            result.put(this._iCompilationUnit, astRewrite);
        }
        return result;
    }

    @Override
    public void performASTChange() {
        if (this._delegateIdentifier.equals("super")) {
            this._project.recursivelyReplaceNodeWithCopy((ASTNode)this._selectedMethodInvocation.getName(), (ASTNode)this._newSuperInvocationNode.getName());
            List oldArguments = this._selectedMethodInvocation.arguments();
            List newArguments = this._newSuperInvocationNode.arguments();
            if (oldArguments.size() == newArguments.size()) {
                int i = 0;
                while (i < oldArguments.size()) {
                    this._project.recursivelyReplaceNodeWithCopy((ASTNode)((Expression)oldArguments.get(i)), (ASTNode)((Expression)newArguments.get(i)));
                    ++i;
                }
            } else {
                throw new RuntimeException("oldArguments.size != newArguments.size()");
            }
            StructuralPropertyDescriptor location = this._selectedMethodInvocation.getLocationInParent();
            if (location.isChildProperty()) {
                this._selectedMethodInvocation.getParent().setStructuralProperty(location, (Object)this._newSuperInvocationNode);
            } else {
                List parentList = (List)this._selectedMethodInvocation.getParent().getStructuralProperty(location);
                parentList.set(parentList.indexOf(this._selectedMethodInvocation), this._newSuperInvocationNode);
            }
        } else {
            if (this._newExpressionNode != null) {
                if (this._newExpressionNode instanceof Name) {
                    this._newExpressionNodeReference = this._project.getReferenceForNode((ASTNode)this._newExpressionNode);
                } else {
                    System.err.println("Unexpected new expression type " + this._newExpressionNode.getClass());
                }
            }
            this._selectedMethodInvocation.setExpression(this._newExpressionNode);
        }
    }

    @Override
    public void updateAfterReparse() {
        if (this._newExpressionNodeReference != null) {
            this._newExpressionNode = (Expression)this._newExpressionNodeReference.getNode();
        }
        if (this._newExpressionNode instanceof SimpleName) {
            SimpleName name = (SimpleName)this._newExpressionNode;
            PMNameModel nameModel = this._project.getNameModel();
            ASTNode declaringNode = this._project.findDeclaringNodeForName((Name)name);
            if (declaringNode != null) {
                SimpleName simpleNameForDeclaringNode = this._project.simpleNameForDeclaringNode(declaringNode);
                String identifier = nameModel.identifierForName((Name)simpleNameForDeclaringNode);
                nameModel.setIdentifierForName(identifier, (Name)name);
            }
            MethodDeclaration methodDeclaration = null;
            ASTNode iterator = name.getParent();
            do {
                if (!(iterator instanceof MethodDeclaration)) continue;
                methodDeclaration = (MethodDeclaration)iterator;
                break;
            } while ((iterator = iterator.getParent()) != null);
            PMRDefsAnalysis analysis = new PMRDefsAnalysis(methodDeclaration);
            PMUse use = analysis.useForSimpleName(name);
            PMUDModel udModel = this._project.getUDModel();
            udModel.addUseToModel(use);
        }
    }
}

