/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.steps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import pm_refactoring.PMASTNodeUtils;
import pm_refactoring.PMProject;
import pm_refactoring.steps.PMStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMExtractMethodStep
extends PMStep {
    MethodDeclaration _extractedMethodDeclaration;
    MethodInvocation _replacementMethodInvocation;
    List<SimpleName> _namesToExtract;
    Expression _originalExpression;
    Expression _extractedExpression;

    public PMExtractMethodStep(PMProject project, Expression expression) {
        super(project);
        this._namesToExtract = PMExtractMethodStep.variablesReferredToInExpression(expression);
        this._originalExpression = expression;
        this._extractedMethodDeclaration = this.newMethodDeclaration();
        this._replacementMethodInvocation = this.newMethodInvocation();
    }

    public List<SimpleName> getNamesToExtract() {
        return new ArrayList<SimpleName>(this._namesToExtract);
    }

    protected MethodDeclaration newMethodDeclaration() {
        AST ast = this._originalExpression.getAST();
        MethodDeclaration newMethodDeclaration = ast.newMethodDeclaration();
        newMethodDeclaration.setName(ast.newSimpleName("extractedMethod"));
        newMethodDeclaration.setReturnType2(PMExtractMethodStep.newTypeASTNodeForTypeBinding(ast, this._originalExpression.resolveTypeBinding()));
        newMethodDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        for (SimpleName nameToExtract : this._namesToExtract) {
            SingleVariableDeclaration parameter = ast.newSingleVariableDeclaration();
            parameter.setName(ast.newSimpleName(nameToExtract.getIdentifier()));
            parameter.setType(PMExtractMethodStep.newTypeASTNodeForTypeBinding(ast, nameToExtract.resolveTypeBinding()));
            newMethodDeclaration.parameters().add(parameter);
        }
        Block methodBody = ast.newBlock();
        newMethodDeclaration.setBody(methodBody);
        ReturnStatement returnStatement = ast.newReturnStatement();
        this._extractedExpression = (Expression)ASTNode.copySubtree((AST)ast, (ASTNode)this._originalExpression);
        returnStatement.setExpression(this._extractedExpression);
        methodBody.statements().add(returnStatement);
        return newMethodDeclaration;
    }

    protected MethodInvocation newMethodInvocation() {
        AST ast = this._originalExpression.getAST();
        MethodInvocation newMethodInvocation = ast.newMethodInvocation();
        newMethodInvocation.setName(ast.newSimpleName(this._extractedMethodDeclaration.getName().getIdentifier()));
        for (SimpleName nameToExtract : this._namesToExtract) {
            newMethodInvocation.arguments().add(ast.newSimpleName(nameToExtract.getIdentifier()));
        }
        return newMethodInvocation;
    }

    private static Type newTypeASTNodeForTypeBinding(AST ast, ITypeBinding typeBinding) {
        if (typeBinding.isPrimitive()) {
            return ast.newPrimitiveType(PrimitiveType.toCode((String)typeBinding.getName()));
        }
        if (typeBinding.isClass() || typeBinding.isInterface()) {
            return ast.newSimpleType((Name)ast.newSimpleName(typeBinding.getName()));
        }
        return null;
    }

    private static List<SimpleName> variablesReferredToInExpression(Expression e) {
        final ArrayList<SimpleName> result = new ArrayList<SimpleName>();
        e.accept(new ASTVisitor(){

            public boolean visit(SimpleName simpleName) {
                IVariableBinding variableNameBinding;
                IBinding nameBinding = simpleName.resolveBinding();
                if (nameBinding instanceof IVariableBinding && (variableNameBinding = (IVariableBinding)nameBinding).getDeclaringMethod() != null) {
                    result.add(simpleName);
                }
                return false;
            }
        });
        return result;
    }

    private TypeDeclaration containingClass(ASTNode node) {
        ASTNode iterator = node;
        while (iterator != null) {
            if (iterator instanceof TypeDeclaration) {
                return (TypeDeclaration)iterator;
            }
            iterator = iterator.getParent();
        }
        return null;
    }

    @Override
    public Map<ICompilationUnit, ASTRewrite> calculateTextualChange() {
        HashMap<ICompilationUnit, ASTRewrite> result = new HashMap<ICompilationUnit, ASTRewrite>();
        AST ast = this._originalExpression.getAST();
        ASTRewrite astRewrite = ASTRewrite.create((AST)ast);
        TypeDeclaration containingClass = this.containingClass((ASTNode)this._originalExpression);
        int insertionIndex = containingClass.bodyDeclarations().size();
        ListRewrite lrw = astRewrite.getListRewrite((ASTNode)containingClass, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
        lrw.insertAt((ASTNode)this._extractedMethodDeclaration, insertionIndex, null);
        astRewrite.replace((ASTNode)this._originalExpression, (ASTNode)this._replacementMethodInvocation, null);
        result.put(this._project.findPMCompilationUnitForNode((ASTNode)this._originalExpression).getICompilationUnit(), astRewrite);
        return result;
    }

    public void performNameModelChange() {
    }

    public void performUDModelChange() {
    }

    @Override
    public void performASTChange() {
        TypeDeclaration containingClass = this.containingClass((ASTNode)this._originalExpression);
        containingClass.bodyDeclarations().add(this._extractedMethodDeclaration);
        this._project.recursivelyReplaceNodeWithCopy((ASTNode)this._originalExpression, (ASTNode)this._extractedExpression);
        PMASTNodeUtils.replaceNodeInParent((ASTNode)this._originalExpression, (ASTNode)this._replacementMethodInvocation);
        this.performNameModelChange();
        this.performUDModelChange();
    }
}

