/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.steps;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import pm_refactoring.PMPasteboard;
import pm_refactoring.PMProject;
import pm_refactoring.models.PMNameModel;
import pm_refactoring.steps.PMStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMPasteStep
extends PMStep {
    ASTNode _parent;
    ChildListPropertyDescriptor _property;
    int _index;

    public PMPasteStep(PMProject project, ASTNode parent, ChildListPropertyDescriptor property, int index) {
        super(project);
        this._parent = parent;
        this._property = property;
        this._index = index;
    }

    @Override
    public Map<ICompilationUnit, ASTRewrite> calculateTextualChange() {
        PMPasteboard pasteboard = this._project.getPasteboard();
        List<ASTNode> nodesToPaste = pasteboard.getPasteboardRoots();
        HashMap<ICompilationUnit, ASTRewrite> result = new HashMap<ICompilationUnit, ASTRewrite>();
        ASTRewrite astRewrite = ASTRewrite.create((AST)this._parent.getAST());
        int index = this._index;
        for (ASTNode nodeToPaste : nodesToPaste) {
            ASTNode copiedNode = ASTNode.copySubtree((AST)this._parent.getAST(), (ASTNode)nodeToPaste);
            ListRewrite lrw = astRewrite.getListRewrite(this._parent, this._property);
            lrw.insertAt(copiedNode, index++, null);
            result.put(this._project.findPMCompilationUnitForNode(this._parent).getICompilationUnit(), astRewrite);
        }
        return result;
    }

    @Override
    public void performASTChange() {
        PMPasteboard pasteboard = this._project.getPasteboard();
        List<ASTNode> nodesToPaste = pasteboard.getPasteboardRoots();
        final PMNameModel nameModel = this._project.getNameModel();
        int i = 0;
        while (i < nodesToPaste.size()) {
            ASTNode node = nodesToPaste.get(i);
            int insertionIndex = i + this._index;
            List childList = (List)this._parent.getStructuralProperty((StructuralPropertyDescriptor)this._property);
            ASTNode copiedNode = ASTNode.copySubtree((AST)this._parent.getAST(), (ASTNode)node);
            childList.add(insertionIndex, copiedNode);
            ASTMatcher identifierMatcher = new ASTMatcher(){

                public boolean match(SimpleName pasteboardName, Object other) {
                    if (super.match(pasteboardName, other)) {
                        SimpleName copyName = (SimpleName)other;
                        String identifier = nameModel.identifierForName((Name)pasteboardName);
                        nameModel.setIdentifierForName(identifier, (Name)copyName);
                        return true;
                    }
                    return false;
                }
            };
            if (!node.subtreeMatch(identifierMatcher, (Object)copiedNode)) {
                System.err.println("Couldn't match copied statement to original");
                throw new RuntimeException("PM Paste Error: Couldn't match copied statement to original");
            }
            this._project.recursivelyReplaceNodeWithCopy(node, copiedNode);
            ++i;
        }
        this._project.updateToNewVersionsOfICompilationUnits();
    }

    @Override
    public void updateAfterReparse() {
    }

    @Override
    public void cleanup() {
    }
}

