/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.steps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import pm_refactoring.PMCompilationUnit;
import pm_refactoring.PMProject;
import pm_refactoring.models.PMNameModel;
import pm_refactoring.steps.PMStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMRenameStep
extends PMStep {
    SimpleName _nameNode;
    String _newName;
    List<SimpleName> _nameNodesToChange;

    public PMRenameStep(PMProject project, SimpleName nameNode) {
        super(project);
        if (nameNode == null) {
            throw new RuntimeException("Cannot create PMRenameStep with null nameNode");
        }
        this._nameNode = nameNode;
        this._nameNodesToChange = new ArrayList<SimpleName>();
    }

    public String getNewName() {
        return this._newName;
    }

    public void setNewName(String newName) {
        this._newName = newName;
    }

    @Override
    public Map<ICompilationUnit, ASTRewrite> calculateTextualChange() {
        HashMap<ICompilationUnit, ASTRewrite> result = new HashMap<ICompilationUnit, ASTRewrite>();
        this._project.syncSources();
        PMNameModel nameModel = this._project.getNameModel();
        ArrayList<SimpleName> nodesToRename = nameModel.nameNodesRelatedToNameNode(this._nameNode);
        this._nameNodesToChange.addAll(nodesToRename);
        HashMap<ICompilationUnit, ArrayList<SimpleName>> nodesByICompilationUnit = new HashMap<ICompilationUnit, ArrayList<SimpleName>>();
        for (SimpleName nodeToRename : nodesToRename) {
            CompilationUnit containingCompilationUnit = (CompilationUnit)nodeToRename.getRoot();
            ICompilationUnit containingICompilationUnit = (ICompilationUnit)containingCompilationUnit.getJavaElement();
            ArrayList<SimpleName> namesForUnit = (ArrayList<SimpleName>)nodesByICompilationUnit.get(containingICompilationUnit);
            if (namesForUnit == null) {
                namesForUnit = new ArrayList<SimpleName>();
                nodesByICompilationUnit.put(containingICompilationUnit, namesForUnit);
            }
            namesForUnit.add(nodeToRename);
        }
        if (nodesByICompilationUnit.size() > 0) {
            for (ICompilationUnit unitForRename : nodesByICompilationUnit.keySet()) {
                List nodesInUnit = (List)nodesByICompilationUnit.get(unitForRename);
                ASTRewrite astRewrite = ASTRewrite.create((AST)((SimpleName)nodesInUnit.get(0)).getAST());
                result.put(unitForRename, astRewrite);
                for (SimpleName sameNode : nodesInUnit) {
                    SimpleName newNode = this._nameNode.getAST().newSimpleName(this._newName);
                    astRewrite.replace((ASTNode)sameNode, (ASTNode)newNode, null);
                }
            }
        }
        return result;
    }

    @Override
    public void performASTChange() {
        for (SimpleName nameNode : this._nameNodesToChange) {
            nameNode.setIdentifier(this._newName);
            if (!(nameNode.getParent() instanceof TypeDeclaration) || !(nameNode.getParent().getParent() instanceof CompilationUnit)) continue;
            ICompilationUnit iCompilationUnitToRename = (ICompilationUnit)((CompilationUnit)nameNode.getParent().getParent()).getJavaElement();
            PMCompilationUnit pmCompilationUnitToRename = this._project.getPMCompilationUnitForICompilationUnit(iCompilationUnitToRename);
            pmCompilationUnitToRename.rename(this._newName);
        }
    }

    @Override
    public void updateAfterReparse() {
    }

    @Override
    public void cleanup() {
    }
}

