/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.tests;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.junit.Assert;
import org.junit.Test;
import pm_refactoring.PMASTQuery;
import pm_refactoring.tests.PMTest;

public class PMASTQueryTest
extends PMTest {
    @Test
    public void testFindClassByName() {
        String source = "class S {int x; int f() {} } class T {} class S {int y; int f() {} }";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source);
        ASTNode secondS = PMASTQuery.nodeForSelectionInCompilationUnit(40, 28, compilationUnit);
        Assert.assertTrue((boolean)(secondS instanceof TypeDeclaration));
        Assert.assertEquals((Object)secondS, (Object)PMASTQuery.classWithNameInCompilationUnit("S", 1, compilationUnit));
    }

    @Test
    public void testFindMethodByName() {
        String source = "class S {int x; int f() {} } class S {int y; int f() {} int f() {} }";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source);
        ASTNode secondF = PMASTQuery.nodeForSelectionInCompilationUnit(56, 10, compilationUnit);
        Assert.assertTrue((boolean)(secondF instanceof MethodDeclaration));
        Assert.assertEquals((Object)secondF, (Object)PMASTQuery.methodWithNameInClassInCompilationUnit("f", 1, "S", 1, compilationUnit));
    }

    @Test
    public void testFindFieldByName() {
        String source = "class S {int x,y; int f() {} int y; int x,y,x; int y; int y,x; int x; }";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source);
        ASTNode field = PMASTQuery.nodeForSelectionInCompilationUnit(60, 1, compilationUnit).getParent();
        Assert.assertTrue((boolean)(field instanceof VariableDeclarationFragment));
        Assert.assertEquals((Object)field, (Object)PMASTQuery.fieldWithNameInClassInCompilationUnit("x", 3, "S", 0, compilationUnit));
    }

    @Test
    public void testFindLocalByName() {
        String source = "class S {int x,y; int f() {int x,y; try {} catch(Exception x){} while(1) {int y,x;} } }";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source);
        ASTNode local = PMASTQuery.nodeForSelectionInCompilationUnit(80, 1, compilationUnit).getParent();
        Assert.assertTrue((boolean)(local instanceof VariableDeclarationFragment));
        Assert.assertEquals((Object)local, (Object)PMASTQuery.localWithNameInMethodInClassInCompilationUnit("x", 2, "f", 0, "S", 0, compilationUnit));
    }

    @Test
    public void testFindSimpleNameByIdentifier() {
        String source = "class S {int x,y; int f(int x) {int x,y; try {x = y + 1;} catch(Exception x){} while(1) {int y,x; x--;} } }";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source);
        ASTNode simpleName = PMASTQuery.nodeForSelectionInCompilationUnit(98, 1, compilationUnit);
        Assert.assertTrue((boolean)(simpleName instanceof SimpleName));
        Assert.assertEquals((Object)simpleName, (Object)PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("x", 4, "f", 0, "S", 0, compilationUnit));
    }
}

