/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.tests;

import java.util.ArrayList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.junit.Assert;
import org.junit.Test;
import pm_refactoring.PMASTQuery;
import pm_refactoring.PMProject;
import pm_refactoring.PMWorkspace;
import pm_refactoring.steps.PMCutStep;
import pm_refactoring.tests.PMTest;

public class PMCutStepTest
extends PMTest {
    @Test
    public void testInstantiation() {
        MethodDeclaration methodDeclaration;
        String source = "public class S {S s; void m(){s.getClass(); m();}}";
        ICompilationUnit compilationUnit = this.createNewCompilationUnit("", "S.java", source);
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        PMCutStep cutStep = new PMCutStep(pmProject, (ASTNode)(methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, (CompilationUnit)pmProject.findASTRootForICompilationUnit(compilationUnit))));
        Assert.assertTrue((cutStep != null ? 1 : 0) != 0);
    }

    @Test
    public void testCutMethod() throws JavaModelException {
        String source = "public class S {S s; void m(){System.out.println(s);}}";
        ICompilationUnit compilationUnit = this.createNewCompilationUnit("", "S.java", source);
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, (CompilationUnit)pmProject.findASTRootForICompilationUnit(compilationUnit));
        PMCutStep cutStep = new PMCutStep(pmProject, (ASTNode)methodDeclaration);
        cutStep.applyAllAtOnce();
        Assert.assertTrue((boolean)this.compilationUnitSourceMatchesSource("public class S {S s;}", compilationUnit.getSource()));
    }

    @Test
    public void testCutStatement() throws JavaModelException {
        String source = "public class S {S s; void m(){System.out.println(s);}}";
        ICompilationUnit compilationUnit = this.createNewCompilationUnit("", "S.java", source);
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, (CompilationUnit)pmProject.findASTRootForICompilationUnit(compilationUnit));
        Statement firstStatement = (Statement)methodDeclaration.getBody().statements().get(0);
        PMCutStep cutStep = new PMCutStep(pmProject, (ASTNode)firstStatement);
        cutStep.applyAllAtOnce();
        Assert.assertTrue((boolean)this.compilationUnitSourceMatchesSource("public class S {S s; void m(){}}", compilationUnit.getSource()));
    }

    @Test
    public void testCutField() throws JavaModelException {
        String source = "public class S {S s; void m(){System.out.println(s);}}";
        ICompilationUnit compilationUnit = this.createNewCompilationUnit("", "S.java", source);
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        VariableDeclarationFragment fieldDeclarationFragment = PMASTQuery.fieldWithNameInClassInCompilationUnit("s", 0, "S", 0, (CompilationUnit)pmProject.findASTRootForICompilationUnit(compilationUnit));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)fieldDeclarationFragment.getParent();
        PMCutStep cutStep = new PMCutStep(pmProject, (ASTNode)fieldDeclaration);
        cutStep.applyAllAtOnce();
        Assert.assertTrue((boolean)this.compilationUnitSourceMatchesSource("public class S {void m(){System.out.println(s);}}", compilationUnit.getSource()));
    }

    @Test
    public void testCutMultipleStatements() throws JavaModelException {
        String source = "public class S {void m(){int x,y; int a; a = 1; y = 3; x = 2;}}";
        ICompilationUnit iCompilationUnit = this.createNewCompilationUnit("", "S.java", source);
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        CompilationUnit compilationUnit = (CompilationUnit)pmProject.findASTRootForICompilationUnit(iCompilationUnit);
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        Statement thirdStatement = (Statement)methodDeclaration.getBody().statements().get(2);
        Statement fourthStatement = (Statement)methodDeclaration.getBody().statements().get(3);
        ArrayList<ASTNode> nodesToCut = new ArrayList<ASTNode>();
        nodesToCut.add((ASTNode)thirdStatement);
        nodesToCut.add((ASTNode)fourthStatement);
        PMCutStep cutStep = new PMCutStep(pmProject, nodesToCut);
        cutStep.applyAllAtOnce();
        Assert.assertTrue((boolean)this.compilationUnitSourceMatchesSource("public class S {void m(){int x,y; int a; x = 2;}}", iCompilationUnit.getSource()));
        Assert.assertEquals((Object)pmProject.getPasteboard().getPasteboardRoots().size(), (Object)2);
        Assert.assertTrue((boolean)pmProject.getPasteboard().containsOnlyNodesOfClass(Statement.class));
    }

    @Test
    public void testCutDeclarationButNotReference() throws JavaModelException {
        String source = "public class S {void m(){int x; x = 1;}}";
        ICompilationUnit iCompilationUnit = this.createNewCompilationUnit("", "S.java", source);
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        CompilationUnit compilationUnit = (CompilationUnit)pmProject.findASTRootForICompilationUnit(iCompilationUnit);
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        Statement secondStatement = (Statement)methodDeclaration.getBody().statements().get(0);
        try {
            PMCutStep cutStep = new PMCutStep(pmProject, (ASTNode)secondStatement);
            cutStep.applyAllAtOnce();
        }
        catch (RuntimeException runtimeException) {
            System.out.println("Shouldn't throw exception");
            Assert.fail((String)"Shouldn't throw exception");
        }
        Assert.assertTrue((boolean)this.compilationUnitSourceMatchesSource("public class S {void m(){x = 1;}}", iCompilationUnit.getSource()));
    }

    @Test
    public void testCutFieldWithReference() throws JavaModelException {
        String source = "public class S {int x; void m(){x = 1;}}";
        ICompilationUnit iCompilationUnit = this.createNewCompilationUnit("", "S.java", source);
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        VariableDeclarationFragment fieldDeclarationFragment = PMASTQuery.fieldWithNameInClassInCompilationUnit("x", 0, "S", 0, (CompilationUnit)pmProject.findASTRootForICompilationUnit(iCompilationUnit));
        FieldDeclaration fieldDeclaration = (FieldDeclaration)fieldDeclarationFragment.getParent();
        PMCutStep cutStep = new PMCutStep(pmProject, (ASTNode)fieldDeclaration);
        cutStep.applyAllAtOnce();
        Assert.assertTrue((boolean)this.compilationUnitSourceMatchesSource("public class S {void m(){x = 1;}}", iCompilationUnit.getSource()));
    }
}

