/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.tests;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.junit.Assert;
import org.junit.Test;
import pm_refactoring.PMASTQuery;
import pm_refactoring.PMCompilationUnit;
import pm_refactoring.PMProject;
import pm_refactoring.PMWorkspace;
import pm_refactoring.steps.PMExtractMethodStep;
import pm_refactoring.tests.PMTest;

public class PMExtractMethodStepTest
extends PMTest {
    @Test
    public void testGetNamesToExtract() {
        String source = "class S {String _s; void m(int i) {int j; System.out.println(_s + i + j);}}";
        ICompilationUnit compilationUnitS = this.createNewCompilationUnit("", "S.java", source);
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        PMCompilationUnit pmCompilationUnitS = pmProject.getPMCompilationUnitForICompilationUnit(compilationUnitS);
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, pmCompilationUnitS.getASTNode());
        Block bodyBlock = methodDeclaration.getBody();
        ExpressionStatement printlnStatement = (ExpressionStatement)bodyBlock.statements().get(1);
        MethodInvocation methodInvocation = (MethodInvocation)printlnStatement.getExpression();
        Expression expression = (Expression)methodInvocation.arguments().get(0);
        PMExtractMethodStep step = new PMExtractMethodStep(pmProject, expression);
        List<SimpleName> namesToExtract = step.getNamesToExtract();
        Assert.assertEquals((Object)2, (Object)namesToExtract.size());
        Assert.assertEquals((Object)PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("i", 0, "m", 0, "S", 0, pmCompilationUnitS.getASTNode()), (Object)namesToExtract.get(0));
        Assert.assertEquals((Object)PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("j", 1, "m", 0, "S", 0, pmCompilationUnitS.getASTNode()), (Object)namesToExtract.get(1));
    }

    @Test
    public void testExtractLocalVariableExpression() {
        String source = "class S {String _s; void m(int i) {int j; System.out.println(_s + i + j);}}";
        ICompilationUnit compilationUnitS = this.createNewCompilationUnit("", "S.java", source);
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        PMCompilationUnit pmCompilationUnitS = pmProject.getPMCompilationUnitForICompilationUnit(compilationUnitS);
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, pmCompilationUnitS.getASTNode());
        Block bodyBlock = methodDeclaration.getBody();
        ExpressionStatement printlnStatement = (ExpressionStatement)bodyBlock.statements().get(1);
        MethodInvocation methodInvocation = (MethodInvocation)printlnStatement.getExpression();
        Expression expression = (Expression)methodInvocation.arguments().get(0);
        PMExtractMethodStep step = new PMExtractMethodStep(pmProject, expression);
        step.applyAllAtOnce();
    }
}

