/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.tests;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.SimpleName;
import org.junit.Assert;
import org.junit.Test;
import pm_refactoring.PMNodeReference;
import pm_refactoring.PMNodeReferenceStore;

public class PMNodeReferenceStoreTest {
    @Test
    public void testStoreBasics() {
        PMNodeReferenceStore store = new PMNodeReferenceStore();
        AST ast = AST.newAST((int)3);
        SimpleName node = ast.newSimpleName("Foo");
        PMNodeReference reference = store.getReferenceForNode((ASTNode)node);
        Assert.assertNotNull((Object)reference);
        assert (store.getReferenceForNode((ASTNode)node) == reference);
        assert (store.getNodeForReference(reference) == reference);
        assert (reference.getNode() == node);
    }

    @Test
    public void testNullingOutNodeRemovesReference() {
        PMNodeReferenceStore store = new PMNodeReferenceStore();
        AST ast = AST.newAST((int)3);
        SimpleName node = ast.newSimpleName("Foo");
        PMNodeReference reference = store.getReferenceForNode((ASTNode)node);
        node = null;
        System.gc();
        Assert.assertNull((Object)store.getNodeForReference(reference));
    }

    @Test
    public void testNullingOutReferenceRemovesNode() {
        PMNodeReferenceStore store = new PMNodeReferenceStore();
        AST ast = AST.newAST((int)3);
        SimpleName node = ast.newSimpleName("Foo");
        PMNodeReference reference = store.getReferenceForNode((ASTNode)node);
        int hashCodeBefore = reference.hashCode();
        reference = null;
        System.gc();
        reference = store.getReferenceForNode((ASTNode)node);
        assert (reference.hashCode() != hashCodeBefore);
    }

    @Test
    public void testReplaceNodeWithNodeWithoutExistingReferenceToNewNode() {
        PMNodeReferenceStore store = new PMNodeReferenceStore();
        AST ast = AST.newAST((int)3);
        SimpleName node1 = ast.newSimpleName("Foo");
        PMNodeReference reference1 = store.getReferenceForNode((ASTNode)node1);
        SimpleName node2 = ast.newSimpleName("Bar");
        store.replaceOldNodeVersionWithNewVersion((ASTNode)node1, (ASTNode)node2);
        Assert.assertSame((Object)node2, (Object)reference1.getNode());
    }

    @Test
    public void testReplaceNodeWithNodeWithExistingReferenceToNewNode() {
        PMNodeReferenceStore store = new PMNodeReferenceStore();
        AST ast = AST.newAST((int)3);
        SimpleName node1 = ast.newSimpleName("Foo");
        PMNodeReference reference1 = store.getReferenceForNode((ASTNode)node1);
        SimpleName node2 = ast.newSimpleName("Bar");
        PMNodeReference reference2 = store.getReferenceForNode((ASTNode)node1);
        store.replaceOldNodeVersionWithNewVersion((ASTNode)node1, (ASTNode)node2);
        Assert.assertSame((Object)node2, (Object)reference1.getNode());
        Assert.assertSame((Object)node2, (Object)reference2.getNode());
    }
}

