/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.tests;

import java.util.HashSet;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.junit.Assert;
import org.junit.Test;
import pm_refactoring.PMASTQuery;
import pm_refactoring.PMProject;
import pm_refactoring.PMWorkspace;
import pm_refactoring.steps.PMCopyStep;
import pm_refactoring.steps.PMCutStep;
import pm_refactoring.steps.PMPasteStep;
import pm_refactoring.tests.PMTest;

public class PMPushDownFieldTest
extends PMTest {
    @Test
    public void testPushDownFieldWithNoUses() throws JavaModelException {
        ICompilationUnit iCompilationUnitS = this.createNewCompilationUnit("", "S.java", "public class S { int _y;}");
        ICompilationUnit iCompilationUnitT1 = this.createNewCompilationUnit("", "T1.java", "public class T1 extends S {  }");
        ICompilationUnit iCompilationUnitT2 = this.createNewCompilationUnit("", "T2.java", "public class T2 extends S {  }");
        PMProject project = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        FieldDeclaration yField = (FieldDeclaration)PMASTQuery.fieldWithNameInClassInCompilationUnit("_y", 0, "S", 0, (CompilationUnit)project.findASTRootForICompilationUnit(iCompilationUnitS)).getParent();
        PMCopyStep copyStep1 = new PMCopyStep(project, (ASTNode)yField);
        yField = null;
        copyStep1.applyAllAtOnce();
        CompilationUnit compilationUnitT1 = (CompilationUnit)project.findASTRootForICompilationUnit(iCompilationUnitT1);
        TypeDeclaration classT1 = PMASTQuery.classWithNameInCompilationUnit("T1", 0, compilationUnitT1);
        PMPasteStep pasteStep1 = new PMPasteStep(project, (ASTNode)classT1, classT1.getBodyDeclarationsProperty(), classT1.bodyDeclarations().size());
        classT1 = null;
        pasteStep1.applyAllAtOnce();
        Assert.assertEquals(new HashSet(), project.allInconsistencies());
        yField = (FieldDeclaration)PMASTQuery.fieldWithNameInClassInCompilationUnit("_y", 0, "S", 0, (CompilationUnit)project.findASTRootForICompilationUnit(iCompilationUnitS)).getParent();
        PMCopyStep copyStep2 = new PMCopyStep(project, (ASTNode)yField);
        yField = null;
        copyStep2.applyAllAtOnce();
        CompilationUnit compilationUnitT2 = (CompilationUnit)project.findASTRootForICompilationUnit(iCompilationUnitT2);
        TypeDeclaration classT2 = PMASTQuery.classWithNameInCompilationUnit("T2", 0, compilationUnitT2);
        PMPasteStep pasteStep2 = new PMPasteStep(project, (ASTNode)classT2, classT2.getBodyDeclarationsProperty(), classT2.bodyDeclarations().size());
        classT2 = null;
        pasteStep2.applyAllAtOnce();
        yField = (FieldDeclaration)PMASTQuery.fieldWithNameInClassInCompilationUnit("_y", 0, "S", 0, (CompilationUnit)project.findASTRootForICompilationUnit(iCompilationUnitS)).getParent();
        PMCutStep cutStep = new PMCutStep(project, (ASTNode)yField);
        yField = null;
        cutStep.applyAllAtOnce();
        Assert.assertEquals(new HashSet(), project.allInconsistencies());
        Assert.assertTrue((boolean)this.compilationUnitSourceMatchesSource("public class S {} }", iCompilationUnitS.getSource()));
        Assert.assertTrue((boolean)this.compilationUnitSourceMatchesSource("public class T1 extends S { int _y;  }", iCompilationUnitT1.getSource()));
        Assert.assertTrue((boolean)this.compilationUnitSourceMatchesSource("public class T2 extends S { int _y;  }", iCompilationUnitT2.getSource()));
    }
}

