/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.tests;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.junit.Assert;
import org.junit.Test;
import pm_refactoring.PMASTQuery;
import pm_refactoring.analysis.PMDef;
import pm_refactoring.analysis.PMRDefsAnalysis;
import pm_refactoring.analysis.PMUse;
import pm_refactoring.tests.PMTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMRDefsAnalysisTest
extends PMTest {
    public void testFindDefinitions() {
        String source = "class S {void m(int x){int y = x - 1; x++; --x; y += (x = y);}}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source);
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        PMRDefsAnalysis rdefs = new PMRDefsAnalysis(methodDeclaration);
        ArrayList<PMDef> definitions = rdefs.getDefinitions();
        Assert.assertEquals((Object)6, (Object)definitions.size());
    }

    @Test
    public void testStraightlineCodeReachingDefsNoUses() {
        String source = "public class S {void m(){int x;x = 1;int y; x = 2; y = 3; x = 5;}}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        PMRDefsAnalysis rdefs = new PMRDefsAnalysis(methodDeclaration);
        Assert.assertEquals((Object)0, (Object)rdefs.getUses().size());
    }

    @Test
    public void testStraightlineCodeUses() {
        String source = "public class S {void m(){int x;x = 1;int y; y = x;}}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        PMRDefsAnalysis rdefs = new PMRDefsAnalysis(methodDeclaration);
        SimpleName firstX = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("x", 0, "m", 0, "S", 0, compilationUnit);
        Assert.assertEquals(null, (Object)rdefs.useForSimpleName(firstX));
        SimpleName secondX = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("x", 1, "m", 0, "S", 0, compilationUnit);
        Assert.assertEquals(null, (Object)rdefs.useForSimpleName(secondX));
        SimpleName thirdX = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("x", 2, "m", 0, "S", 0, compilationUnit);
        PMUse thirdXUse = rdefs.useForSimpleName(thirdX);
        Assert.assertTrue((thirdXUse != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)1, (Object)thirdXUse.getReachingDefinitions().size());
        Assignment xAssignment = PMASTQuery.assignmentInMethodInClassInCompilationUnit(0, "m", 0, "S", 0, compilationUnit);
        PMDef xAssignmentDef = (PMDef)thirdXUse.getReachingDefinitions().toArray()[0];
        Assert.assertTrue((xAssignmentDef != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)xAssignment, (Object)xAssignmentDef.getDefiningNode());
    }

    @Test
    public void testUseInExpressionStatement() {
        SimpleName thirdX;
        String source = "public class S {void m(){String x;x = \"foo\";System.out.println(x);}}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        PMRDefsAnalysis rdefs = new PMRDefsAnalysis(methodDeclaration);
        PMUse thirdXUse = rdefs.useForSimpleName(thirdX = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("x", 2, "m", 0, "S", 0, compilationUnit));
        Assert.assertTrue((thirdXUse != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)1, (Object)thirdXUse.getReachingDefinitions().size());
        Assignment xAssignment = PMASTQuery.assignmentInMethodInClassInCompilationUnit(0, "m", 0, "S", 0, compilationUnit);
        PMDef xAssignmentDef = (PMDef)thirdXUse.getReachingDefinitions().toArray()[0];
        Assert.assertEquals((Object)xAssignment, (Object)xAssignmentDef.getDefiningNode());
    }

    @Test
    public void testDefiningInitializer() {
        String source = "public class S {void m(){int x = 0;x = x + 1;}}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        PMRDefsAnalysis rdefs = new PMRDefsAnalysis(methodDeclaration);
        SimpleName firstX = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("x", 0, "m", 0, "S", 0, compilationUnit);
        Assert.assertEquals(null, (Object)rdefs.useForSimpleName(firstX));
        SimpleName secondX = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("x", 1, "m", 0, "S", 0, compilationUnit);
        Assert.assertEquals(null, (Object)rdefs.useForSimpleName(secondX));
        SimpleName thirdX = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("x", 2, "m", 0, "S", 0, compilationUnit);
        PMUse thirdXUse = rdefs.useForSimpleName(thirdX);
        Assert.assertTrue((thirdXUse != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)1, (Object)thirdXUse.getReachingDefinitions().size());
        PMDef xInitializerDef = (PMDef)thirdXUse.getReachingDefinitions().toArray()[0];
        VariableDeclaration xDeclaration = PMASTQuery.localWithNameInMethodInClassInCompilationUnit("x", 0, "m", 0, "S", 0, compilationUnit);
        Assert.assertEquals((Object)xDeclaration, (Object)xInitializerDef.getDefiningNode());
    }

    @Test
    public void testUseInInitializer() {
        String source = "public class S {void m(){int y = 1;int x = y;}}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        PMRDefsAnalysis rdefs = new PMRDefsAnalysis(methodDeclaration);
        SimpleName firstY = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("y", 0, "m", 0, "S", 0, compilationUnit);
        Assert.assertEquals(null, (Object)rdefs.useForSimpleName(firstY));
        SimpleName firstX = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("x", 0, "m", 0, "S", 0, compilationUnit);
        Assert.assertEquals(null, (Object)rdefs.useForSimpleName(firstX));
        SimpleName secondY = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("y", 1, "m", 0, "S", 0, compilationUnit);
        PMUse secondYUse = rdefs.useForSimpleName(secondY);
        Assert.assertTrue((secondYUse != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)1, (Object)secondYUse.getReachingDefinitions().size());
        PMDef defForSecondYUse = (PMDef)secondYUse.getReachingDefinitions().toArray()[0];
        VariableDeclaration yDeclaration = PMASTQuery.localWithNameInMethodInClassInCompilationUnit("y", 0, "m", 0, "S", 0, compilationUnit);
        Assert.assertEquals((Object)yDeclaration, (Object)defForSecondYUse.getDefiningNode());
    }

    @Test
    public void testUseInPostIncrement() {
        SimpleName secondY;
        String source = "public class S {void m(){int y = 1;int x = y++;}}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        PMRDefsAnalysis rdefs = new PMRDefsAnalysis(methodDeclaration);
        PMUse secondYUse = rdefs.useForSimpleName(secondY = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("y", 1, "m", 0, "S", 0, compilationUnit));
        Assert.assertTrue((secondYUse != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)1, (Object)secondYUse.getReachingDefinitions().size());
        PMDef defForSecondYUse = (PMDef)secondYUse.getReachingDefinitions().toArray()[0];
        VariableDeclaration yDeclaration = PMASTQuery.localWithNameInMethodInClassInCompilationUnit("y", 0, "m", 0, "S", 0, compilationUnit);
        Assert.assertEquals((Object)yDeclaration, (Object)defForSecondYUse.getDefiningNode());
    }

    @Test
    public void testDefinitionInPostIncrement() {
        SimpleName thirdY;
        String source = "public class S {void m(){int y = 1; y++; int x = y;}}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        PMRDefsAnalysis rdefs = new PMRDefsAnalysis(methodDeclaration);
        PMUse thirdYUse = rdefs.useForSimpleName(thirdY = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("y", 2, "m", 0, "S", 0, compilationUnit));
        Assert.assertTrue((thirdYUse != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)1, (Object)thirdYUse.getReachingDefinitions().size());
        PMDef defForThirdYUse = (PMDef)thirdYUse.getReachingDefinitions().toArray()[0];
        PostfixExpression yPlusPlus = (PostfixExpression)PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("y", 1, "m", 0, "S", 0, compilationUnit).getParent();
        Assert.assertEquals((Object)yPlusPlus, (Object)defForThirdYUse.getDefiningNode());
    }

    @Test
    public void testDefinitionsInIfThenElseBody() {
        SimpleName fourthY;
        String source = "public class S {void m(){int y = 1; if (true) y = 5; else y = 6; System.out.println(y);}}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        PMRDefsAnalysis rdefs = new PMRDefsAnalysis(methodDeclaration);
        PMUse fourthYUse = rdefs.useForSimpleName(fourthY = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("y", 3, "m", 0, "S", 0, compilationUnit));
        Assert.assertTrue((fourthYUse != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)2, (Object)fourthYUse.getReachingDefinitions().size());
        Object[] definitions = fourthYUse.getReachingDefinitions().toArray();
        PMDef definition1 = (PMDef)definitions[0];
        PMDef definition2 = (PMDef)definitions[1];
        Assignment yEquals5 = PMASTQuery.assignmentInMethodInClassInCompilationUnit(0, "m", 0, "S", 0, compilationUnit);
        Assignment yEquals6 = PMASTQuery.assignmentInMethodInClassInCompilationUnit(1, "m", 0, "S", 0, compilationUnit);
        Assert.assertTrue((definition1.getDefiningNode() == yEquals5 && definition2.getDefiningNode() == yEquals6 || definition1.getDefiningNode() == yEquals6 && definition2.getDefiningNode() == yEquals5 ? 1 : 0) != 0);
    }

    @Test
    public void testDefinitionsInIfThenBody() {
        SimpleName thirdY;
        String source = "public class S {void m(){int y = 1; if (true) y = 5; System.out.println(y);}}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        PMRDefsAnalysis rdefs = new PMRDefsAnalysis(methodDeclaration);
        PMUse thirdYUse = rdefs.useForSimpleName(thirdY = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("y", 2, "m", 0, "S", 0, compilationUnit));
        Assert.assertTrue((thirdYUse != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)2, (Object)thirdYUse.getReachingDefinitions().size());
        Object[] definitions = thirdYUse.getReachingDefinitions().toArray();
        PMDef definition1 = (PMDef)definitions[0];
        PMDef definition2 = (PMDef)definitions[1];
        VariableDeclaration yEquals1 = PMASTQuery.localWithNameInMethodInClassInCompilationUnit("y", 0, "m", 0, "S", 0, compilationUnit);
        Assignment yEquals5 = PMASTQuery.assignmentInMethodInClassInCompilationUnit(0, "m", 0, "S", 0, compilationUnit);
        Assert.assertTrue((definition1.getDefiningNode() == yEquals1 && definition2.getDefiningNode() == yEquals5 || definition1.getDefiningNode() == yEquals5 && definition2.getDefiningNode() == yEquals1 ? 1 : 0) != 0);
    }

    Set<ASTNode> definingNodesFromDefinitions(Set<PMDef> definitions) {
        HashSet<ASTNode> definingNodes = new HashSet<ASTNode>();
        for (PMDef definition : definitions) {
            definingNodes.add(definition.getDefiningNode());
        }
        return definingNodes;
    }

    @Test
    public void testDefinitionsInNestedIfThenElse() {
        SimpleName sixthY;
        String source = "public class S {void m(){int y = 1; if (true) { if (false) y = 2; else y = 3;} else {if (true) y = 4; else y = 5;} System.out.println(y);}}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        PMRDefsAnalysis rdefs = new PMRDefsAnalysis(methodDeclaration);
        PMUse sixthYUse = rdefs.useForSimpleName(sixthY = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("y", 5, "m", 0, "S", 0, compilationUnit));
        Assert.assertTrue((sixthYUse != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)4, (Object)sixthYUse.getReachingDefinitions().size());
        Set<ASTNode> definingNodes = this.definingNodesFromDefinitions(sixthYUse.getReachingDefinitions());
        Assignment yEquals2 = PMASTQuery.assignmentInMethodInClassInCompilationUnit(0, "m", 0, "S", 0, compilationUnit);
        Assignment yEquals3 = PMASTQuery.assignmentInMethodInClassInCompilationUnit(1, "m", 0, "S", 0, compilationUnit);
        Assignment yEquals4 = PMASTQuery.assignmentInMethodInClassInCompilationUnit(2, "m", 0, "S", 0, compilationUnit);
        Assignment yEquals5 = PMASTQuery.assignmentInMethodInClassInCompilationUnit(3, "m", 0, "S", 0, compilationUnit);
        Assert.assertTrue((boolean)definingNodes.contains(yEquals2));
        Assert.assertTrue((boolean)definingNodes.contains(yEquals3));
        Assert.assertTrue((boolean)definingNodes.contains(yEquals4));
        Assert.assertTrue((boolean)definingNodes.contains(yEquals5));
    }

    @Test
    public void testDefinitionsInWhileLoop() {
        SimpleName fourthY;
        String source = "public class S {void m(){int y = 1; while(y < 6) {y = y + 1;} System.out.println(y);}}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        PMRDefsAnalysis rdefs = new PMRDefsAnalysis(methodDeclaration);
        PMUse fourthYUse = rdefs.useForSimpleName(fourthY = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("y", 3, "m", 0, "S", 0, compilationUnit));
        Assert.assertTrue((fourthYUse != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)2, (Object)fourthYUse.getReachingDefinitions().size());
        Set<ASTNode> fourthYUseDefiningNodes = this.definingNodesFromDefinitions(fourthYUse.getReachingDefinitions());
        VariableDeclaration yEquals1 = PMASTQuery.localWithNameInMethodInClassInCompilationUnit("y", 0, "m", 0, "S", 0, compilationUnit);
        Assignment yEqualsYPlus1 = PMASTQuery.assignmentInMethodInClassInCompilationUnit(0, "m", 0, "S", 0, compilationUnit);
        Assert.assertTrue((boolean)fourthYUseDefiningNodes.contains(yEquals1));
        Assert.assertTrue((boolean)fourthYUseDefiningNodes.contains(yEqualsYPlus1));
        SimpleName fifthY = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("y", 4, "m", 0, "S", 0, compilationUnit);
        PMUse fifthYUse = rdefs.useForSimpleName(fifthY);
        Assert.assertTrue((fifthYUse != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)2, (Object)fifthYUse.getReachingDefinitions().size());
        Set<ASTNode> fifthYUseDefiningNodes = this.definingNodesFromDefinitions(fourthYUse.getReachingDefinitions());
        Assert.assertTrue((boolean)fifthYUseDefiningNodes.contains(yEquals1));
        Assert.assertTrue((boolean)fifthYUseDefiningNodes.contains(yEqualsYPlus1));
    }

    @Test
    public void testUseOfInstanceVariableWithoutDefinition() {
        String source = "public class S {int y; void m(){System.out.println(y);}}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        PMRDefsAnalysis rdefs = new PMRDefsAnalysis(methodDeclaration);
        SimpleName secondY = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("y", 0, "m", 0, "S", 0, compilationUnit);
        Assert.assertTrue((secondY != null ? 1 : 0) != 0);
        PMUse secondYUse = rdefs.useForSimpleName(secondY);
        Assert.assertEquals((Object)1, (Object)secondYUse.getReachingDefinitions().size());
        Assert.assertEquals(null, (Object)secondYUse.getReachingDefinitions().toArray()[0]);
    }

    @Test
    public void testUseOfInstanceVariableBeforeDefinition() {
        String source = "public class S {int y; void m(){System.out.println(y); y = 5;}}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        PMRDefsAnalysis rdefs = new PMRDefsAnalysis(methodDeclaration);
        SimpleName secondY = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("y", 0, "m", 0, "S", 0, compilationUnit);
        Assert.assertTrue((secondY != null ? 1 : 0) != 0);
        PMUse secondYUse = rdefs.useForSimpleName(secondY);
        Assert.assertEquals((Object)1, (Object)secondYUse.getReachingDefinitions().size());
        Assert.assertEquals(null, (Object)secondYUse.getReachingDefinitions().toArray()[0]);
    }

    @Test
    public void testMethodParameterWithoutUse() {
        String source = "public class S {void m(String object){ }}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        PMRDefsAnalysis rdefs = new PMRDefsAnalysis(methodDeclaration);
        rdefs.toString();
    }

    @Test
    public void testMethodParameterWithUse() {
        String source = "public class S {void m(String x){System.out.println(x); }}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        PMRDefsAnalysis rdefs = new PMRDefsAnalysis(methodDeclaration);
        SimpleName firstX = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("x", 0, "m", 0, "S", 0, compilationUnit);
        Assert.assertTrue((firstX != null ? 1 : 0) != 0);
        PMUse firstXUse = rdefs.useForSimpleName(firstX);
        Assert.assertEquals((Object)1, (Object)firstXUse.getReachingDefinitions().size());
        Assert.assertEquals(null, (Object)firstXUse.getReachingDefinitions().toArray()[0]);
    }

    @Test
    public void testFieldAccessDefinition() {
        String source = "public class S {int y;void m(S x){x.y = 1; }}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        PMRDefsAnalysis rdefs = new PMRDefsAnalysis(methodDeclaration);
        rdefs.toString();
    }

    @Test
    public void testNonDefiningPrefixExpression() {
        String source = "public class S {bool y;void m(){if (!y);}}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        PMRDefsAnalysis rdefs = new PMRDefsAnalysis(methodDeclaration);
        rdefs.toString();
    }

    @Test
    public void testArrrayAccessDefinition() {
        String source = "public class S {int[] y;void m(){y[5] = 6;}}";
        CompilationUnit compilationUnit = this.parseCompilationUnitFromSource(source, "S.java");
        MethodDeclaration methodDeclaration = PMASTQuery.methodWithNameInClassInCompilationUnit("m", 0, "S", 0, compilationUnit);
        PMRDefsAnalysis rdefs = new PMRDefsAnalysis(methodDeclaration);
        rdefs.toString();
    }
}

