/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.tests;

import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.junit.Assert;
import org.junit.Test;
import pm_refactoring.PMASTQuery;
import pm_refactoring.PMProject;
import pm_refactoring.PMRenameProcessor;
import pm_refactoring.PMWorkspace;
import pm_refactoring.inconsistencies.PMInconsistency;
import pm_refactoring.inconsistencies.PMMissingDefinition;
import pm_refactoring.inconsistencies.PMNameCapture;
import pm_refactoring.tests.PMProcessorDriver;
import pm_refactoring.tests.PMTest;

public class PMRenameProcessorTest
extends PMTest {
    @Test
    public void testCreateNewCompilationUnitInTest() {
        ICompilationUnit iCompilationUnit = this.createNewCompilationUnit("", "Foo.java", "public class Foo {}");
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        Assert.assertTrue((pmProject.getPMCompilationUnitForICompilationUnit(iCompilationUnit) != null ? 1 : 0) != 0);
    }

    @Test
    public void testRenameLocalVariableViaDeclaration() throws JavaModelException {
        ICompilationUnit iCompilationUnit = this.createNewCompilationUnit("", "Foo.java", "public class Foo {void method() {int foo; foo = 5;} }");
        PMRenameProcessor renameFooToStan = new PMRenameProcessor((ITextSelection)new TextSelection(37, 3), iCompilationUnit);
        renameFooToStan.setNewName("stan");
        PMProcessorDriver.drive((RefactoringProcessor)renameFooToStan);
        Assert.assertEquals((Object)"public class Foo {void method() {int stan; stan = 5;} }", (Object)iCompilationUnit.getSource());
        PMRenameProcessor renameStanToBar = new PMRenameProcessor((ITextSelection)new TextSelection(37, 4), iCompilationUnit);
        renameStanToBar.setNewName("bar");
        PMProcessorDriver.drive((RefactoringProcessor)renameStanToBar);
        Assert.assertEquals((Object)"public class Foo {void method() {int bar; bar = 5;} }", (Object)iCompilationUnit.getSource());
    }

    @Test
    public void testRenameLocalVariableViaUse() throws JavaModelException {
        ICompilationUnit iCompilationUnit = this.createNewCompilationUnit("", "Foo.java", "public class Foo {void method() {int foo; foo = 5;} }");
        PMRenameProcessor renameFooToStan = new PMRenameProcessor((ITextSelection)new TextSelection(42, 3), iCompilationUnit);
        renameFooToStan.setNewName("stan");
        PMProcessorDriver.drive((RefactoringProcessor)renameFooToStan);
        Assert.assertEquals((Object)"public class Foo {void method() {int stan; stan = 5;} }", (Object)iCompilationUnit.getSource());
        PMRenameProcessor renameStanToBar = new PMRenameProcessor((ITextSelection)new TextSelection(43, 4), iCompilationUnit);
        renameStanToBar.setNewName("bar");
        PMProcessorDriver.drive((RefactoringProcessor)renameStanToBar);
        Assert.assertEquals((Object)"public class Foo {void method() {int bar; bar = 5;} }", (Object)iCompilationUnit.getSource());
    }

    @Test
    public void testRenameIVarCapturesLocal() throws JavaModelException {
        ICompilationUnit iCompilationUnit = this.createNewCompilationUnit("", "Foo.java", "public class Foo {int foo; void method() {int bar; foo = 5;} }");
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        PMRenameProcessor renameIvarToBar = new PMRenameProcessor((ITextSelection)new TextSelection(22, 3), iCompilationUnit);
        renameIvarToBar.setNewName("bar");
        PMProcessorDriver.drive((RefactoringProcessor)renameIvarToBar);
        Assert.assertEquals((String)"Foo.java", (Object)"public class Foo {int bar; void method() {int bar; bar = 5;} }", (Object)iCompilationUnit.getSource());
        Set<PMInconsistency> inconsistencies = pmProject.allInconsistencies();
        Assert.assertEquals((Object)1, (Object)inconsistencies.size());
        PMNameCapture nameCapture = (PMNameCapture)inconsistencies.toArray()[0];
        CompilationUnit parsedCompilationUnit = pmProject.parsedCompilationUnitForICompilationUnit(iCompilationUnit);
        SimpleName expectedCapturedNode = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("bar", 1, "method", 0, "Foo", 0, parsedCompilationUnit);
        Assert.assertEquals((Object)expectedCapturedNode, (Object)nameCapture.getNode());
        ASTNode expectedCapturingNode = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("bar", 0, "method", 0, "Foo", 0, parsedCompilationUnit).getParent();
        ASTNode actualCapturingNode = nameCapture.getActualDeclaration();
        Assert.assertEquals((Object)expectedCapturingNode, (Object)actualCapturingNode);
    }

    @Test
    public void testRenameThroughCapture() throws JavaModelException {
        ICompilationUnit iCompilationUnit = this.createNewCompilationUnit("", "Foo.java", "public class Foo {void method() {int foo; int bar; foo = 5; bar = 6;} }");
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        PMRenameProcessor renameFooToBar = new PMRenameProcessor((ITextSelection)new TextSelection(37, 3), iCompilationUnit);
        renameFooToBar.setNewName("bar");
        PMProcessorDriver.drive((RefactoringProcessor)renameFooToBar);
        Assert.assertEquals((Object)"public class Foo {void method() {int bar; int bar; bar = 5; bar = 6;} }", (Object)iCompilationUnit.getSource());
        Set<PMInconsistency> inconsistencies = pmProject.allInconsistencies();
        Assert.assertTrue((inconsistencies.size() == 1 ? 1 : 0) != 0);
        PMNameCapture nameCapture = (PMNameCapture)inconsistencies.toArray()[0];
        CompilationUnit parsedCompilationUnit = pmProject.parsedCompilationUnitForICompilationUnit(iCompilationUnit);
        ASTNode expectedCapturedNode = pmProject.nodeForSelection((ITextSelection)new TextSelection(51, 3), iCompilationUnit);
        Assert.assertEquals((Object)expectedCapturedNode, (Object)nameCapture.getNode());
        ASTNode expectedCapturingNode = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("bar", 1, "method", 0, "Foo", 0, parsedCompilationUnit).getParent();
        ASTNode actualCapturingNode = nameCapture.getActualDeclaration();
        Assert.assertEquals((Object)expectedCapturingNode, (Object)actualCapturingNode);
        PMRenameProcessor renameBarToFoo = new PMRenameProcessor((ITextSelection)new TextSelection(60, 3), iCompilationUnit);
        renameBarToFoo.setNewName("foo");
        PMProcessorDriver.drive((RefactoringProcessor)renameBarToFoo);
        Assert.assertEquals((Object)"public class Foo {void method() {int bar; int foo; bar = 5; foo = 6;} }", (Object)iCompilationUnit.getSource());
        inconsistencies = pmProject.allInconsistencies();
        Assert.assertTrue((inconsistencies.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRenameInMultipleFiles() throws JavaModelException {
        ICompilationUnit unit1 = this.createNewCompilationUnit("", "Unit1.java", "public class Unit1 { public int x; void method() {x++;} }");
        ICompilationUnit unit2 = this.createNewCompilationUnit("", "Unit2.java", "public class Unit2 { void method() {Unit1 unit1 = new Unit1(); unit1.x--;} }");
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        PMRenameProcessor renameXToY = new PMRenameProcessor((ITextSelection)new TextSelection(32, 1), unit1);
        renameXToY.setNewName("y");
        PMProcessorDriver.drive((RefactoringProcessor)renameXToY);
        Assert.assertEquals((Object)"public class Unit1 { public int y; void method() {y++;} }", (Object)unit1.getSource());
        Assert.assertEquals((Object)"public class Unit2 { void method() {Unit1 unit1 = new Unit1(); unit1.y--;} }", (Object)unit2.getSource());
        for (PMInconsistency inconsistency : pmProject.allInconsistencies()) {
            System.out.println(inconsistency.getHumanReadableDescription());
            if (!(inconsistency instanceof PMMissingDefinition)) continue;
            System.out.println("For definition of class: " + ((PMMissingDefinition)inconsistency).getDefiningNode().getClass());
        }
        Assert.assertTrue((pmProject.allInconsistencies().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAcceptNameCapture() throws JavaModelException {
        ICompilationUnit iCompilationUnit = this.createNewCompilationUnit("", "Foo.java", "public class Foo {int foo; void method() {int bar; foo = 5;} }");
        PMProject pmProject = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        PMRenameProcessor renameIvarToBar = new PMRenameProcessor((ITextSelection)new TextSelection(22, 3), iCompilationUnit);
        renameIvarToBar.setNewName("bar");
        PMProcessorDriver.drive((RefactoringProcessor)renameIvarToBar);
        Assert.assertEquals((String)"Foo.java", (Object)"public class Foo {int bar; void method() {int bar; bar = 5;} }", (Object)iCompilationUnit.getSource());
        Set<PMInconsistency> inconsistencies = pmProject.allInconsistencies();
        Assert.assertTrue((inconsistencies.size() == 1 ? 1 : 0) != 0);
        PMNameCapture nameCapture = (PMNameCapture)inconsistencies.toArray()[0];
        CompilationUnit parsedCompilationUnit = pmProject.parsedCompilationUnitForICompilationUnit(iCompilationUnit);
        SimpleName expectedCapturedNode = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("bar", 1, "method", 0, "Foo", 0, parsedCompilationUnit);
        Assert.assertEquals((Object)expectedCapturedNode, (Object)nameCapture.getNode());
        nameCapture.acceptBehavioralChange();
        Set<PMInconsistency> newInconsistencies = pmProject.allInconsistencies();
        Assert.assertEquals((Object)0, (Object)newInconsistencies.size());
    }
}

