/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.tests;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.junit.Assert;
import org.junit.Test;
import pm_refactoring.PMASTQuery;
import pm_refactoring.PMNodeReference;
import pm_refactoring.PMProject;
import pm_refactoring.PMWorkspace;
import pm_refactoring.models.PMNameModel;
import pm_refactoring.models.PMUDModel;
import pm_refactoring.steps.PMSplitStep;
import pm_refactoring.tests.PMTest;

public class PMSplitStepTest
extends PMTest {
    @Test
    public void testSimplestCase() throws JavaModelException {
        ICompilationUnit iCompilationUnit = this.createNewCompilationUnit("", "S.java", "public class S { void m() {int x; x = 7; x = 5; System.out.println(x);} }");
        PMProject project = PMWorkspace.sharedWorkspace().projectForIJavaProject(this._iJavaProject);
        Assignment secondAssignment = PMASTQuery.assignmentInMethodInClassInCompilationUnit(1, "m", 0, "S", 0, (CompilationUnit)project.findASTRootForICompilationUnit(iCompilationUnit));
        ExpressionStatement assignmentStatement = (ExpressionStatement)secondAssignment.getParent();
        PMSplitStep step = new PMSplitStep(project, assignmentStatement);
        step.applyAllAtOnce();
        Assert.assertTrue((boolean)this.compilationUnitSourceMatchesSource("public class S { void m() {int x; x = 7; int x = 5; System.out.println(x);} }", iCompilationUnit.getSource()));
        PMNameModel nameModel = project.getNameModel();
        SimpleName firstX = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("x", 0, "m", 0, "S", 0, (CompilationUnit)project.findASTRootForICompilationUnit(iCompilationUnit));
        SimpleName secondX = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("x", 1, "m", 0, "S", 0, (CompilationUnit)project.findASTRootForICompilationUnit(iCompilationUnit));
        Assert.assertNotNull((Object)nameModel.identifierForName((Name)firstX));
        Assert.assertNotNull((Object)nameModel.identifierForName((Name)secondX));
        Assert.assertEquals((Object)nameModel.identifierForName((Name)firstX), (Object)nameModel.identifierForName((Name)secondX));
        SimpleName thirdX = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("x", 2, "m", 0, "S", 0, (CompilationUnit)project.findASTRootForICompilationUnit(iCompilationUnit));
        SimpleName fourthX = PMASTQuery.simpleNameWithIdentifierInMethodInClassInCompilationUnit("x", 3, "m", 0, "S", 0, (CompilationUnit)project.findASTRootForICompilationUnit(iCompilationUnit));
        Assert.assertNotNull((Object)nameModel.identifierForName((Name)thirdX));
        Assert.assertNotNull((Object)nameModel.identifierForName((Name)fourthX));
        Assert.assertEquals((Object)nameModel.identifierForName((Name)thirdX), (Object)nameModel.identifierForName((Name)fourthX));
        Assert.assertTrue((!nameModel.identifierForName((Name)firstX).equals(nameModel.identifierForName((Name)thirdX)) ? 1 : 0) != 0);
        ArrayList<SimpleName> nodesRelatedToFirstDeclaration = nameModel.nameNodesRelatedToNameNode(firstX);
        Assert.assertEquals((Object)2, (Object)nodesRelatedToFirstDeclaration.size());
        Assert.assertTrue((boolean)nodesRelatedToFirstDeclaration.contains(firstX));
        Assert.assertTrue((boolean)nodesRelatedToFirstDeclaration.contains(secondX));
        ArrayList<SimpleName> nodesRelatedToSecondDeclaration = nameModel.nameNodesRelatedToNameNode(thirdX);
        Assert.assertEquals((Object)2, (Object)nodesRelatedToSecondDeclaration.size());
        Assert.assertTrue((boolean)nodesRelatedToSecondDeclaration.contains(thirdX));
        Assert.assertTrue((boolean)nodesRelatedToSecondDeclaration.contains(fourthX));
        PMUDModel udModel = project.getUDModel();
        VariableDeclarationFragment secondXDeclaration = (VariableDeclarationFragment)thirdX.getParent();
        Set<PMNodeReference> usesOfSecondDeclaration = udModel.usesForDefinition(project.getReferenceForNode((ASTNode)secondXDeclaration));
        Assert.assertEquals((Object)1, (Object)usesOfSecondDeclaration.size());
        VariableDeclarationStatement expectedReplacementDeclaration = (VariableDeclarationStatement)secondXDeclaration.getParent();
        Assert.assertTrue((expectedReplacementDeclaration == step.getReplacementDeclarationStatement() ? 1 : 0) != 0);
    }
}

