/*
 * Decompiled with CFR 0.152.
 */
package pm_refactoring.tests;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.launching.JavaRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import pm_refactoring.PMWorkspace;

public class PMTest {
    protected IProject _iProject = null;
    protected IJavaProject _iJavaProject = null;

    @After
    public void deleteProject() {
        try {
            PMWorkspace.sharedWorkspace().removeProjectForIJavaProject(this._iJavaProject);
            this._iProject.delete(true, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this._iProject = null;
        this._iJavaProject = null;
    }

    @Before
    public void createProject() {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            this._iProject = root.getProject("pm_test_project_name");
            if (this._iProject.exists()) {
                this._iProject.delete(true, null);
            }
            this._iProject.create(null);
            this._iProject.open(null);
            IProjectDescription description = this._iProject.getDescription();
            description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
            this._iProject.setDescription(description, null);
            this._iJavaProject = JavaCore.create((IProject)this._iProject);
            IClasspathEntry[] buildPath = new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)this._iProject.getFullPath().append("src")), JavaRuntime.getDefaultJREContainerEntry()};
            this._iJavaProject.setRawClasspath(buildPath, this._iProject.getFullPath().append("bin"), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public ICompilationUnit createNewCompilationUnit(String packageFragmentName, String fileName, String sourceText) {
        ICompilationUnit result = null;
        try {
            IFolder folder = this._iProject.getFolder("src");
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            IPackageFragmentRoot srcFolder = this._iJavaProject.getPackageFragmentRoot((IResource)folder);
            Assert.assertTrue((boolean)srcFolder.exists());
            IPackageFragment fragment = srcFolder.createPackageFragment(packageFragmentName, true, null);
            result = fragment.createCompilationUnit(fileName, sourceText, false, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public CompilationUnit parseCompilationUnitFromSource(String source, String unitName) {
        ASTParser parser = ASTParser.newParser((int)3);
        if (unitName != null) {
            ICompilationUnit iCompilationUnit = this.createNewCompilationUnit("", unitName, source);
            parser.setSource(iCompilationUnit);
        } else {
            parser.setSource(source.toCharArray());
        }
        parser.setResolveBindings(true);
        parser.setUnitName(unitName);
        parser.setProject(this._iJavaProject);
        return (CompilationUnit)parser.createAST(null);
    }

    public CompilationUnit parseCompilationUnitFromSource(String source) {
        return this.parseCompilationUnitFromSource(source, null);
    }

    public boolean compilationUnitSourceMatchesSource(String source1, String source2) {
        CompilationUnit compilationUnit1 = this.parseCompilationUnitFromSource(source1);
        CompilationUnit compilationUnit2 = this.parseCompilationUnitFromSource(source2);
        return compilationUnit1.subtreeMatch(new ASTMatcher(), (Object)compilationUnit2);
    }
}

